/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.classgraph;

import java.lang.reflect.Field;
import org.srplib.contract.Argument;
import org.srplib.reflection.ReflectionUtils;

public class ClassGraphNode {
    private final Field field;
    private final Class type;

    public static ClassGraphNode create(Class context, String fieldName) {
        return ClassGraphNode.create(ReflectionUtils.getFieldRecursively((Class)context, (String)fieldName));
    }

    public static ClassGraphNode create(Field field) {
        Argument.checkNotNull((Object)field, (String)"field must not be null!", (Object[])new Object[0]);
        return new ClassGraphNode(field.getType(), field);
    }

    public static ClassGraphNode create(Class type) {
        return new ClassGraphNode(type, null);
    }

    protected ClassGraphNode(Class type, Field field) {
        Argument.checkNotNull((Object)type, (String)"type must not be null", (Object[])new Object[0]);
        this.type = type;
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public Class getType() {
        return this.type;
    }

    public boolean isRoot() {
        return this.field == null;
    }

    public String toString() {
        String fieldName = this.field != null ? this.field.getName() : "null";
        return String.format("[field: '%s', class: %s]", fieldName, this.type);
    }
}

