/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.reflection.classgraph;

import java.lang.reflect.Field;
import org.srplib.contract.Argument;
import org.srplib.reflection.ReflectionUtils;
import org.srplib.reflection.classgraph.ClassGraphNode;
import org.srplib.reflection.classgraph.ClassGraphVisitor;
import org.srplib.reflection.classgraph.TraversableNodesFilter;
import org.srplib.support.Predicate;
import org.srplib.visitor.Element;
import org.srplib.visitor.NodePath;

public class ClassGraph<N extends ClassGraphNode, V extends ClassGraphVisitor<N>>
implements Element<N, V> {
    private Class root;
    private Predicate<ClassGraphNode> filter;

    public ClassGraph(Class root, Predicate<ClassGraphNode> filter) {
        Argument.checkNotNull((Object)root, (String)"root must not be null!", (Object[])new Object[0]);
        Argument.checkNotNull(filter, (String)"filter must not be null!", (Object[])new Object[0]);
        this.root = root;
        this.filter = filter;
    }

    public ClassGraph(Class root) {
        this(root, new TraversableNodesFilter());
    }

    @Override
    public void accept(V visitor) {
        Object node = visitor.resolveNode(ClassGraphNode.create(this.root));
        this.traverse(new NodePath(node), visitor);
    }

    private void traverse(NodePath<N> path, V visitor) {
        visitor.visit(path);
        if (!this.isTraversable(path)) {
            return;
        }
        ClassGraphNode node = (ClassGraphNode)path.getCurrent();
        for (Field field : ReflectionUtils.getFieldsRecursively((Class)node.getType())) {
            Object newNode = visitor.resolveNode(ClassGraphNode.create(field));
            this.traverse(path.add(newNode), visitor);
        }
    }

    private boolean isTraversable(NodePath<N> path) {
        return this.filter.test(path.getCurrent());
    }
}

