/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.model;

import org.srplib.contract.Assert;
import org.srplib.model.AbstractValueModel;
import org.srplib.model.ContextDependentValueModel;
import org.srplib.reflection.ReflectionUtils;

public class BeanPropertyValueAdapter<B, T>
extends AbstractValueModel<T>
implements ContextDependentValueModel<B, T> {
    private String property;
    private Object context;

    public static <B, T> BeanPropertyValueAdapter<B, T> forBean(B bean, String property) {
        BeanPropertyValueAdapter valueAdapter = new BeanPropertyValueAdapter(bean.getClass(), property);
        valueAdapter.setContext(bean);
        return valueAdapter;
    }

    public static <B, T> BeanPropertyValueAdapter<B, T> forClass(Class<B> beanClass, String property) {
        return new BeanPropertyValueAdapter<B, T>(beanClass, property);
    }

    public BeanPropertyValueAdapter(Class<B> beanClass, String property) {
        super(ReflectionUtils.getFieldType(beanClass, (String)property));
        this.property = property;
    }

    public void setValue(T value) {
        Assert.checkNotNull((Object)this.context, (String)"Context object isn't set!", (Object[])new Object[0]);
        ReflectionUtils.setFieldValue((Object)this.context, (String)this.property, value);
    }

    public T getValue() {
        Assert.checkNotNull((Object)this.context, (String)"Context object was not set!", (Object[])new Object[0]);
        return (T)ReflectionUtils.getFieldValue((Object)this.context, (String)this.property);
    }

    public void setContext(B context) {
        this.context = context;
    }
}

