/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion.mapper;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;
import org.srplib.conversion.Converter;

public class MatcherMapConverter<I, O>
implements Converter<I, O>,
Serializable {
    private static final long serialVersionUID = -1L;
    public static final String DEFAULT_NO_MATCH_MESSAGE_PATTERN = "No matching value for '%s'.";
    private Map<Matcher<I>, O> matcherMap;
    private O defaultValue;
    private boolean throwExceptionOnNoMatch = true;
    private String noMatchMessagePattern = "No matching value for '%s'.";

    public MatcherMapConverter(Map<Matcher<I>, O> matcherMap) {
        Argument.checkNotNull(matcherMap, (String)"matcherMap must not be null!", (Object[])new Object[0]);
        this.matcherMap = matcherMap;
    }

    protected MatcherMapConverter() {
        this.matcherMap = new HashMap<Matcher<I>, O>();
    }

    protected final void put(Matcher<I> key, O value) {
        this.matcherMap.put(key, value);
    }

    public O getDefaultValue() {
        return this.defaultValue;
    }

    public void setThrowExceptionOnNoMatch(boolean throwExceptionOnNoMatch) {
        this.throwExceptionOnNoMatch = throwExceptionOnNoMatch;
    }

    public void setDefaultValue(O defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setNoMatchMessagePattern(String pattern) {
        Assert.checkNotNull((Object)pattern, (String)"Message pattern must not be null!", (Object[])new Object[0]);
        Assert.checkTrue((boolean)pattern.contains("%s"), (String)"Message pattern '%s' is not valid string format pattern!", (Object[])new Object[]{pattern});
        this.noMatchMessagePattern = pattern;
    }

    public O convert(I input) {
        for (Map.Entry<Matcher<I>, O> entry : this.matcherMap.entrySet()) {
            Matcher<I> matcher = entry.getKey();
            if (!matcher.matches(input)) continue;
            return entry.getValue();
        }
        Argument.checkFalse((this.defaultValue == null && this.throwExceptionOnNoMatch ? 1 : 0) != 0, (String)this.noMatchMessagePattern, (Object[])new Object[]{input});
        return this.defaultValue;
    }
}

