/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.util.Map;
import org.srplib.contract.Argument;
import org.srplib.contract.Assert;
import org.srplib.conversion.Converter;

public class SwitchConverter<I, O>
implements Converter<I, O> {
    public static final String DEFAULT_NO_MATCH_MESSAGE_PATTERN = "There is no mapped value for key '%s'.";
    private Map<I, O> map;
    private O defaultValue;
    private boolean defaultValueSet = false;
    private String noMatchMessagePattern = "There is no mapped value for key '%s'.";

    public SwitchConverter(Map<I, O> map) {
        Argument.checkNotNull(map, (String)"Values map must not be null.", (Object[])new Object[0]);
        this.map = map;
        this.defaultValueSet = false;
    }

    public SwitchConverter(Map<I, O> map, O defaultValue) {
        Argument.checkNotNull(map, (String)"Values map must not be null.", (Object[])new Object[0]);
        this.map = map;
        this.defaultValue = defaultValue;
        this.defaultValueSet = true;
    }

    public void setNoMatchMessagePattern(String pattern) {
        Assert.checkNotNull((Object)pattern, (String)"Message pattern must not be null!", (Object[])new Object[0]);
        Assert.checkTrue((boolean)pattern.contains("%s"), (String)"Message pattern '%s' is not valid string format pattern!", (Object[])new Object[]{pattern});
        this.noMatchMessagePattern = pattern;
    }

    public O convert(I input) {
        boolean valueExists = this.map.containsKey(input);
        Argument.checkTrue((valueExists || this.defaultValueSet ? 1 : 0) != 0, (String)this.noMatchMessagePattern, (Object[])new Object[]{input});
        return valueExists ? this.map.get(input) : this.defaultValue;
    }
}

