/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.srplib.contract.Argument;
import org.srplib.conversion.Converter;
import org.srplib.conversion.ConverterException;

public class StringToDateConverter
implements Converter<String, Date> {
    private static final String ISO_DATE_PATTERN = "yyyy-MM-dd";
    private String format;

    public StringToDateConverter(String format) {
        Argument.checkNotNull((Object)format, (String)"format", (Object[])new Object[0]);
        this.createDateFormat(format);
        this.format = format;
    }

    public StringToDateConverter() {
        this(ISO_DATE_PATTERN);
    }

    public Date convert(String input) {
        try {
            Date result = null;
            if (!this.isBlank(input)) {
                result = this.createDateFormat(this.format).parse(input);
            }
            return result;
        }
        catch (ParseException e) {
            throw new ConverterException("Can't convert '" + input + "' to Date.", (Throwable)e);
        }
    }

    private boolean isBlank(String string) {
        return string == null || "".equals(string.trim());
    }

    private SimpleDateFormat createDateFormat(String format) {
        return new SimpleDateFormat(format);
    }
}

