/*
 * Decompiled with CFR 0.152.
 */
package org.srplib.conversion;

import java.util.Collection;
import org.srplib.contract.Argument;
import org.srplib.conversion.Converter;

public class FormatConverter<I>
implements Converter<I, String> {
    private String pattern;

    private FormatConverter(String pattern) {
        Argument.checkNotNull((Object)pattern, (String)"String pattern must not be null!", (Object[])new Object[0]);
        this.pattern = pattern;
    }

    public String convert(I input) {
        return String.format(this.pattern, this.toArray(input));
    }

    private Object toArray(I input) {
        Object[] result;
        if (input == null) {
            result = null;
        } else if (input.getClass().isArray()) {
            result = (Object[])input;
        } else if (input instanceof Collection) {
            Collection collection = (Collection)input;
            result = collection.toArray(new Object[collection.size()]);
        } else {
            result = String.valueOf(input);
        }
        return result;
    }
}

