/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class TypeReference<T> {
    private final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    public Type getType() {
        return this.type;
    }

    public final Class<T> getRawType() {
        Class<?> rawType;
        Class<?> result = rawType = TypeReference.getRawType(this.type);
        return result;
    }

    static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return (Class)parameterizedType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            return TypeReference.getArrayClass(TypeReference.getRawType(genericArrayType.getGenericComponentType()));
        }
        if (type instanceof TypeVariable) {
            return TypeReference.getRawType(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return TypeReference.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        throw new AssertionError((Object)(type + " unsupported"));
    }

    static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }
}

