/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.squirrelframework.foundation.component.SquirrelInstanceProvider;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.AnonymousAction;
import org.squirrelframework.foundation.fsm.ImmutableLinkedState;
import org.squirrelframework.foundation.fsm.MutableLinkedState;
import org.squirrelframework.foundation.fsm.StateContext;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.StateMachineContext;
import org.squirrelframework.foundation.fsm.StateMachineStatus;
import org.squirrelframework.foundation.fsm.impl.StateImpl;

class LinkedStateImpl<T extends StateMachine<T, S, E, C>, S, E, C>
extends StateImpl<T, S, E, C>
implements ImmutableLinkedState<T, S, E, C>,
MutableLinkedState<T, S, E, C> {
    private SquirrelInstanceProvider<? extends StateMachine<?, S, E, C>> provider;
    private Map<String, StateMachine<? extends StateMachine<?, S, E, C>, S, E, C>> linkedStateMachineInstances = Maps.newConcurrentMap();
    private Action<T, S, E, C> lastEntryAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S from, S to, E event, C context, T stateMachine) {
            StateMachine linkedStateMachine = LinkedStateImpl.this.getLinkedStateMachine(stateMachine);
            linkedStateMachine.start(context);
        }

        @Override
        public String name() {
            return "__LINK_STATE_ENTRY_ACTION";
        }
    };
    private Action<T, S, E, C> firstExitAction = new AnonymousAction<T, S, E, C>(){

        @Override
        public void execute(S from, S to, E event, C context, T stateMachine) {
            StateMachine linkedStateMachine = (StateMachine)LinkedStateImpl.this.linkedStateMachineInstances.remove(LinkedStateImpl.this.getKey(stateMachine));
            if (linkedStateMachine != null) {
                linkedStateMachine.terminate(context);
            }
        }

        @Override
        public String name() {
            return "__LINK_STATE_EXIT_ACTION";
        }
    };

    LinkedStateImpl(S stateId) {
        super(stateId);
    }

    @Override
    public void setLinkedStateMachineProvider(SquirrelInstanceProvider<? extends StateMachine<?, S, E, C>> provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void internalFire(StateContext<T, S, E, C> stateContext) {
        StateMachine<StateMachine<?, S, E, C>, S, E, C> stateMachine = this.linkedStateMachineInstances.get(this.getKey(stateContext.getStateMachine().getThis()));
        if (stateMachine.getStatus() == StateMachineStatus.TERMINATED) {
            super.internalFire(stateContext);
        } else {
            DeclineEventHandler declinedEventHandler = new DeclineEventHandler(stateContext);
            try {
                stateMachine.addTransitionDeclinedListener(declinedEventHandler);
                StateMachineContext.set(stateMachine.getThis(), StateMachineContext.isTestEvent());
                stateMachine.fire(stateContext.getEvent(), stateContext.getContext());
            }
            finally {
                StateMachineContext.set(null);
                stateMachine.removeTransitionDecleindListener(declinedEventHandler);
            }
        }
    }

    @Override
    public StateMachine<? extends StateMachine<?, S, E, C>, S, E, C> getLinkedStateMachine(T stateMachine) {
        String key = this.getKey(stateMachine);
        StateMachine<StateMachine<Object, S, E, C>, S, E, C> linkedStateMachine = this.linkedStateMachineInstances.get(key);
        if (linkedStateMachine == null) {
            linkedStateMachine = this.provider.get();
            this.linkedStateMachineInstances.put(key, linkedStateMachine);
        }
        return linkedStateMachine;
    }

    @Override
    public List<Action<T, S, E, C>> getEntryActions() {
        ArrayList<Action<T, S, E, C>> actions = new ArrayList<Action<T, S, E, C>>();
        actions.addAll(this.entryActions.getAll());
        actions.add(this.lastEntryAction);
        return Collections.unmodifiableList(actions);
    }

    @Override
    public List<Action<T, S, E, C>> getExitActions() {
        ArrayList actions = new ArrayList();
        actions.add(this.firstExitAction);
        actions.addAll(this.exitActions.getAll());
        return Collections.unmodifiableList(actions);
    }

    @Override
    public void verify() {
        if (this.provider == null) {
            throw new IllegalStateException("Linked state machine provider cannot be null.");
        }
        if (this.isParallelState() || this.hasChildStates()) {
            throw new IllegalStateException("Linked state cannot be parallel state or has any child states.");
        }
        super.verify();
    }

    class DeclineEventHandler<M>
    implements StateMachine.TransitionDeclinedListener<T, S, E, C> {
        private StateContext<T, S, E, C> orgStateContext;

        DeclineEventHandler(StateContext<T, S, E, C> orgStateContext) {
            this.orgStateContext = orgStateContext;
        }

        @Override
        public void transitionDeclined(StateMachine.TransitionDeclinedEvent<T, S, E, C> event) {
            LinkedStateImpl.super.internalFire(this.orgStateContext);
        }
    }
}

