/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm.impl;

import java.util.List;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.MethodReference;
import org.squirrelframework.foundation.fsm.MutableState;
import org.squirrelframework.foundation.fsm.StateMachine;
import org.squirrelframework.foundation.fsm.builder.EntryExitActionBuilder;
import org.squirrelframework.foundation.fsm.impl.ExecutionContext;
import org.squirrelframework.foundation.fsm.impl.FSM;
import org.squirrelframework.foundation.fsm.impl.MethodCallActionProxyImpl;
import org.squirrelframework.foundation.fsm.impl.MethodReferenceActionImpl;

class EntryExitActionBuilderImpl<T extends StateMachine<T, S, E, C>, S, E, C>
implements EntryExitActionBuilder<T, S, E, C>,
SquirrelComponent {
    private final boolean isEntryAction;
    private final MutableState<T, S, E, C> state;
    private final ExecutionContext executionContext;

    EntryExitActionBuilderImpl(MutableState<T, S, E, C> state, boolean isEntryAction, ExecutionContext executionContext) {
        this.state = state;
        this.isEntryAction = isEntryAction;
        this.executionContext = executionContext;
    }

    @Override
    public void perform(Action<T, S, E, C> action) {
        if (this.isEntryAction) {
            this.state.addEntryAction(action);
        } else {
            this.state.addExitAction(action);
        }
    }

    @Override
    public void perform(List<? extends Action<T, S, E, C>> actions) {
        if (this.isEntryAction) {
            this.state.addEntryActions(actions);
        } else {
            this.state.addExitActions(actions);
        }
    }

    @Override
    public void evalMvel(String expression) {
        Action action = FSM.newMvelAction(expression, this.executionContext);
        this.perform(action);
    }

    @Override
    public void callMethod(String methodName) {
        MethodCallActionProxyImpl action = FSM.newMethodCallActionProxy(methodName, this.executionContext);
        this.perform(action);
    }

    @Override
    public void invokeMethod(MethodReference<T, S, E, C> methodReference) {
        MethodReferenceActionImpl<T, S, E, C> action = FSM.newMethodReferenceAction(methodReference);
        this.perform(action);
    }
}

