/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.fsm;

import java.util.List;
import org.squirrelframework.foundation.fsm.AnonymousCondition;
import org.squirrelframework.foundation.fsm.Condition;

public class Conditions {
    public static <C> boolean isSatified(Condition<C> condition, C context) {
        return condition != null && context != null && condition.isSatisfied(context);
    }

    public static <C> boolean isNotSatified(Condition<C> condition, C context) {
        return condition == null || context == null || !condition.isSatisfied(context);
    }

    public static <C> Condition<C> always() {
        return new Always();
    }

    public static <C> Condition<C> never() {
        return new Never();
    }

    public static <C> Condition<C> and(final Condition<C> first, final Condition<C> second) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                return first.isSatisfied(context) && second.isSatisfied(context);
            }

            @Override
            public String name() {
                return first.name() + "And" + second.name();
            }
        };
    }

    public static <C> Condition<C> and(final List<Condition<C>> conditions) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                for (Condition condition : conditions) {
                    if (condition.isSatisfied(context)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public String name() {
                String name = null;
                for (Condition c : conditions) {
                    if (name == null) {
                        name = c.name();
                        continue;
                    }
                    name = name + "And" + c.name();
                }
                return name;
            }
        };
    }

    public static <C> Condition<C> or(final Condition<C> first, final Condition<C> second) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                return first.isSatisfied(context) || second.isSatisfied(context);
            }

            @Override
            public String name() {
                return first.name() + "Or" + second.name();
            }
        };
    }

    public static <C> Condition<C> or(final List<Condition<C>> conditions) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                for (Condition condition : conditions) {
                    if (!condition.isSatisfied(context)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String name() {
                String name = null;
                for (Condition c : conditions) {
                    if (name == null) {
                        name = c.name();
                        continue;
                    }
                    name = name + "Or" + c.name();
                }
                return name;
            }
        };
    }

    public static <C> Condition<C> not(final Condition<C> condition) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                return !condition.isSatisfied(context);
            }

            @Override
            public String name() {
                return "Not" + condition.name();
            }
        };
    }

    public static <C> Condition<C> xor(final Condition<C> first, final Condition<C> second) {
        return new Condition<C>(){

            @Override
            public boolean isSatisfied(C context) {
                return first.isSatisfied(context) ^ second.isSatisfied(context);
            }

            @Override
            public String name() {
                return first.name() + "Xor" + second.name();
            }
        };
    }

    public static class Never<C>
    extends AnonymousCondition<C> {
        @Override
        public boolean isSatisfied(C context) {
            return false;
        }
    }

    public static class Always<C>
    extends AnonymousCondition<C> {
        @Override
        public boolean isSatisfied(C context) {
            return true;
        }
    }
}

