/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component.impl;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import org.squirrelframework.foundation.component.Observable;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.event.ListenerMethod;
import org.squirrelframework.foundation.event.PolymEventDispatcher;
import org.squirrelframework.foundation.event.SquirrelEvent;
import org.squirrelframework.foundation.util.ReflectUtils;

public abstract class AbstractSubject
implements Observable {
    private boolean notifiable = true;
    private PolymEventDispatcher eventDispatcher;

    @Override
    public boolean isNotifiable() {
        return this.notifiable;
    }

    @Override
    public void setNotifiable(boolean notifiable) {
        this.notifiable = notifiable;
    }

    @Override
    public void addListener(Class<?> eventType, Object listener, Method method) {
        if (this.eventDispatcher == null) {
            this.eventDispatcher = SquirrelProvider.getInstance().newInstance(PolymEventDispatcher.class);
        }
        this.eventDispatcher.register(eventType, listener, method);
    }

    @Override
    public void addListener(Class<?> eventType, Object listener, String methodName) {
        Method method = ReflectUtils.getFirstMethodOfName(listener.getClass(), methodName);
        this.addListener(eventType, listener, method);
    }

    @Override
    public void removeListener(Predicate<ListenerMethod> predicate) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(predicate);
        }
    }

    @Override
    public void removeListener(Class<?> eventType, Object listener, Method method) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(eventType, listener, method);
        }
    }

    @Override
    public int getListenerSize() {
        return this.eventDispatcher != null ? this.eventDispatcher.getListenerSize() : 0;
    }

    @Override
    public void removeListener(Class<?> eventType, Object listener, String methodName) {
        Method method = ReflectUtils.getFirstMethodOfName(listener.getClass(), methodName);
        this.removeListener(eventType, listener, method);
    }

    @Override
    public void removeListener(Class<?> eventType, Object listener) {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregister(eventType, listener);
        }
    }

    @Override
    public void removeAllListeners() {
        if (this.eventDispatcher != null) {
            this.eventDispatcher.unregisterAll();
        }
    }

    @Override
    public void fireEvent(SquirrelEvent event) {
        if (this.eventDispatcher != null && this.isNotifiable()) {
            this.eventDispatcher.fireEvent(event);
        }
    }
}

