/*
 * Decompiled with CFR 0.152.
 */
package org.squirrelframework.foundation.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.squirrelframework.foundation.component.SquirrelComponent;
import org.squirrelframework.foundation.component.SquirrelPostProcessor;
import org.squirrelframework.foundation.component.SquirrelProvider;
import org.squirrelframework.foundation.component.SquirrelSingleton;
import org.squirrelframework.foundation.component.impl.CompositePostProcessorImpl;
import org.squirrelframework.foundation.util.ClassComparator;
import org.squirrelframework.foundation.util.ReflectUtils;
import org.squirrelframework.foundation.util.TypeReference;

public class SquirrelPostProcessorProvider
implements SquirrelComponent,
SquirrelSingleton {
    private static SquirrelPostProcessorProvider instance = new SquirrelPostProcessorProvider();
    private Map<Class<?>, SquirrelPostProcessor<?>> postProcessorRegistry = new ConcurrentHashMap();

    public static SquirrelPostProcessorProvider getInstance() {
        return instance;
    }

    public static void setInstance(SquirrelPostProcessorProvider instance) {
        SquirrelPostProcessorProvider.instance = instance;
    }

    public <T> void register(Class<T> componentClass, SquirrelPostProcessor<? super T> postProcessor) {
        Method method = ReflectUtils.getFirstMethodOfName(postProcessor.getClass(), "postProcess");
        Class<?>[] params = method.getParameterTypes();
        Preconditions.checkArgument((params.length == 1 ? 1 : 0) != 0, (Object)("Parameter size of method " + method.getName() + " is not match."));
        Preconditions.checkArgument((boolean)params[0].isAssignableFrom(componentClass), (Object)("Parameter type of method " + method.getName() + " is not correct."));
        if (this.postProcessorRegistry.containsKey(componentClass)) {
            SquirrelPostProcessor<?> existedProcessor = this.postProcessorRegistry.get(componentClass);
            if (existedProcessor instanceof CompositePostProcessorImpl) {
                ((CompositePostProcessorImpl)existedProcessor).compose(postProcessor);
            } else {
                this.postProcessorRegistry.remove(componentClass);
                CompositePostProcessorImpl<T> compositeProcessor = new CompositePostProcessorImpl<T>(existedProcessor);
                compositeProcessor.compose(postProcessor);
                this.postProcessorRegistry.put(componentClass, compositeProcessor);
            }
        } else {
            this.postProcessorRegistry.put(componentClass, postProcessor);
        }
    }

    public <T> void register(Class<T> componentClass, Class<? extends SquirrelPostProcessor<? super T>> postProcessorClass) {
        SquirrelPostProcessor<? super T> postProcessor = SquirrelProvider.getInstance().newInstance(postProcessorClass);
        this.register(componentClass, postProcessor);
    }

    public void unregister(Class<?> componentClass) {
        this.postProcessorRegistry.remove(componentClass);
    }

    public void clearRegistry() {
        this.postProcessorRegistry.clear();
    }

    public <T> SquirrelPostProcessor<T> getPostProcessor(Class<T> componentClass) {
        return this.postProcessorRegistry.get(componentClass);
    }

    public <T> List<SquirrelPostProcessor<? super T>> getCallablePostProcessors(Class<T> componentClass) {
        ArrayList postProcessors = Lists.newArrayList();
        for (Map.Entry<Class<?>, SquirrelPostProcessor<?>> entry : this.postProcessorRegistry.entrySet()) {
            if (!entry.getKey().isAssignableFrom(componentClass)) continue;
            SquirrelPostProcessor<?> postProcessor = entry.getValue();
            postProcessors.add(postProcessor);
        }
        return postProcessors;
    }

    public <T> SquirrelPostProcessor<? super T> getBestMatchPostProcessor(Class<T> componentClass, Comparator<SquirrelPostProcessor<? super T>> comparator) {
        List<SquirrelPostProcessor<T>> processors = this.getCallablePostProcessors(componentClass);
        if (processors.isEmpty()) {
            return null;
        }
        Collections.sort(processors, comparator);
        return processors.get(0);
    }

    public <T> SquirrelPostProcessor<? super T> getBestMatchPostProcessor(Class<T> componentClass) {
        return this.getBestMatchPostProcessor(componentClass, new ClassComparator<SquirrelPostProcessor<? super T>>());
    }

    public <T> void register(Class<T> componentClass, TypeReference<? extends SquirrelPostProcessor<? super T>> typeReference) {
        this.register(componentClass, typeReference.getRawType());
    }

    public <T> void register(TypeReference<T> typeRefComponent, SquirrelPostProcessor<? super T> postProcessor) {
        this.register(typeRefComponent.getRawType(), postProcessor);
    }
}

