/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.xd.tuple.DefaultTuple;
import org.springframework.xd.tuple.DefaultTupleConversionService;
import org.springframework.xd.tuple.JsonStringToTupleConverter;
import org.springframework.xd.tuple.LocaleAwareStringToNumberConverterFactory;
import org.springframework.xd.tuple.StringToDateConverter;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.TupleToJsonStringConverter;

public class TupleBuilder {
    private List<String> names = new ArrayList<String>();
    private List<Object> values = new ArrayList<Object>();
    private static final ConfigurableConversionService defaultConversionService;
    private ConfigurableConversionService customConversionService = null;
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final Locale DEFAULT_LOCALE;
    private static Converter<Tuple, String> tupleToStringConverter;
    private static Converter<String, Tuple> stringToTupleConverter;
    private static final IdGenerator defaultIdGenerator;

    public static TupleBuilder tuple() {
        return new TupleBuilder();
    }

    public Tuple of(String k1, Object v1) {
        return this.newTuple(TupleBuilder.namesOf(k1), TupleBuilder.valuesOf(v1));
    }

    public Tuple of(String k1, Object v1, String k2, Object v2) {
        this.addEntry(k1, v1);
        this.addEntry(k2, v2);
        return this.build();
    }

    public Tuple of(String k1, Object v1, String k2, Object v2, String k3, Object v3) {
        this.addEntry(k1, v1);
        this.addEntry(k2, v2);
        this.addEntry(k3, v3);
        return this.build();
    }

    public Tuple of(String k1, Object v1, String k2, Object v2, String k3, Object v3, String k4, Object v4) {
        this.addEntry(k1, v1);
        this.addEntry(k2, v2);
        this.addEntry(k3, v3);
        this.addEntry(k4, v4);
        return this.build();
    }

    public Tuple ofNamesAndValues(List<String> names, List<Object> values) {
        this.names = names;
        this.values = values;
        return this.build();
    }

    public TupleBuilder put(String k1, Object v1) {
        this.addEntry(k1, v1);
        return this;
    }

    public TupleBuilder putAll(Tuple tuple) {
        for (int i = 0; i < tuple.size(); ++i) {
            Object value = tuple.getValues().get(i);
            String name = tuple.getFieldNames().get(i);
            this.addEntry(name, value);
        }
        return this;
    }

    public Tuple build() {
        return this.newTuple(this.names, this.values);
    }

    public static Tuple fromString(String source) {
        return (Tuple)stringToTupleConverter.convert((Object)source);
    }

    public TupleBuilder setConfigurableConversionService(ConfigurableConversionService formattingConversionService) {
        Assert.notNull((Object)formattingConversionService);
        this.customConversionService = formattingConversionService;
        return this;
    }

    public ConversionServiceBuilder setFormats(Locale locale, DateFormat dateFormat) {
        return new ConversionServiceBuilder(this, locale, dateFormat);
    }

    void addEntry(String k1, Object v1) {
        this.names.add(k1);
        this.values.add(v1);
    }

    static List<Object> valuesOf(Object v1) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(v1);
        return Collections.unmodifiableList(values);
    }

    static List<String> namesOf(String k1) {
        ArrayList<String> fields = new ArrayList<String>(1);
        fields.add(k1);
        return Collections.unmodifiableList(fields);
    }

    protected Tuple newTuple(List<String> names, List<Object> values) {
        DefaultTuple tuple = this.customConversionService != null ? new DefaultTuple(names, values, this.customConversionService) : new DefaultTuple(names, values, defaultConversionService);
        tuple.setTupleToStringConverter(tupleToStringConverter);
        return tuple;
    }

    static {
        DEFAULT_LOCALE = Locale.US;
        tupleToStringConverter = new TupleToJsonStringConverter();
        stringToTupleConverter = new JsonStringToTupleConverter();
        defaultIdGenerator = new AlternativeJdkIdGenerator();
        defaultConversionService = new DefaultTupleConversionService();
        defaultConversionService.addConverterFactory((ConverterFactory)new LocaleAwareStringToNumberConverterFactory(NumberFormat.getInstance(DEFAULT_LOCALE)));
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
        dateFormat.setLenient(false);
        defaultConversionService.addConverter((Converter)new StringToDateConverter(dateFormat));
    }

    public static class ConversionServiceBuilder {
        private TupleBuilder builder;
        private Locale locale;
        private DateFormat dateFormat;

        ConversionServiceBuilder(TupleBuilder builder, Locale locale, DateFormat dateFormat) {
            this.builder = builder;
            this.locale = locale;
            this.dateFormat = dateFormat;
        }

        public TupleBuilder setConfigurableConversionService(ConfigurableConversionService formattingConversionService) {
            Assert.notNull((Object)formattingConversionService);
            if (this.locale != null) {
                formattingConversionService.addConverterFactory((ConverterFactory)new LocaleAwareStringToNumberConverterFactory(NumberFormat.getInstance(this.locale)));
            }
            if (this.dateFormat != null) {
                formattingConversionService.addConverter((Converter)new StringToDateConverter(this.dateFormat));
            }
            this.builder.setConfigurableConversionService(formattingConversionService);
            return this.builder;
        }
    }
}

