/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.core.convert.converter.Converter;
import org.springframework.xd.tuple.JsonNodeToTupleConverter;
import org.springframework.xd.tuple.Tuple;

public class JsonBytesToTupleConverter
implements Converter<byte[], Tuple> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonNodeToTupleConverter jsonNodeToTupleConverter = new JsonNodeToTupleConverter();

    public JsonBytesToTupleConverter() {
        this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }

    public Tuple convert(byte[] source) {
        if (source == null) {
            return null;
        }
        try {
            return this.jsonNodeToTupleConverter.convert(this.mapper.readTree(source));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

