/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.tuple;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.xd.tuple.StringToDateConverter;
import org.springframework.xd.tuple.Tuple;
import org.springframework.xd.tuple.TupleToJsonStringConverter;

public class DefaultTuple
implements Tuple {
    private List<String> names;
    private List<Object> values;
    private transient ConfigurableConversionService configurableConversionService;
    private transient Converter<Tuple, String> tupleToStringConverter = new TupleToJsonStringConverter();

    public DefaultTuple(List<String> names, List<Object> values, ConfigurableConversionService configurableConversionService) {
        Assert.notNull(names);
        Assert.notNull(values);
        Assert.notNull((Object)configurableConversionService);
        if (values.size() != names.size()) {
            throw new IllegalArgumentException("Field names must be same length as values: names=" + names + ", values=" + values);
        }
        this.names = new ArrayList<String>(names);
        this.values = new ArrayList<Object>(values);
        this.configurableConversionService = configurableConversionService;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public List<String> getFieldNames() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    public List<Object> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public int getFieldCount() {
        return this.names.size();
    }

    @Override
    public boolean hasFieldName(String name) {
        return this.names.contains(name);
    }

    @Override
    public Object getValue(String name) {
        int index = this.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("Field name [" + name + "] does not exist");
        }
        return this.getValue(index);
    }

    @Override
    public Object getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public List<Class> getFieldTypes() {
        ArrayList types = new ArrayList(this.values.size());
        for (Object val : this.values) {
            types.add(val.getClass());
        }
        return Collections.unmodifiableList(types);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.names == null ? 0 : this.names.hashCode());
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultTuple)) {
            return false;
        }
        DefaultTuple other = (DefaultTuple)obj;
        if (this.names == null ? other.names != null : !this.names.equals(other.names)) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }

    @Override
    public String getString(String name) {
        int index = this.indexOf(name);
        return index == -1 ? null : this.getString(index);
    }

    @Override
    public String getString(int index) {
        return this.readAndTrim(index);
    }

    @Override
    public Tuple getTuple(int index) {
        return this.convert(this.values.get(index), Tuple.class);
    }

    @Override
    public Tuple getTuple(String name) {
        return this.getTuple(this.indexOf(name));
    }

    private String readAndTrim(int index) {
        Object rawValue = this.values.get(index);
        if (rawValue != null) {
            String value = this.convert(rawValue, String.class);
            if (value != null) {
                return value.trim();
            }
            return null;
        }
        return null;
    }

    @Override
    public String getRawString(String name) {
        int index = this.indexOf(name);
        return index == -1 ? null : this.getRawString(index);
    }

    @Override
    public String getRawString(int index) {
        Object rawValue = this.values.get(index);
        if (rawValue != null) {
            String value = this.convert(rawValue, String.class);
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    @Override
    public char getChar(int index) {
        String value = this.readAndTrim(index);
        if (value != null) {
            Assert.isTrue((value.length() == 1 ? 1 : 0) != 0, (String)("Cannot convert field value '" + value + "' to char."));
            return value.charAt(0);
        }
        return '\u0000';
    }

    @Override
    public char getChar(String name) {
        return this.getChar(this.indexOf(name));
    }

    @Override
    public boolean getBoolean(int index) {
        return this.getBoolean(index, "true");
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(this.indexOf(name));
    }

    @Override
    public boolean getBoolean(int index, String trueValue) {
        Assert.notNull((Object)trueValue, (String)"'trueValue' cannot be null.");
        String value = this.readAndTrim(index);
        return trueValue.equals(value);
    }

    @Override
    public boolean getBoolean(String name, String trueValue) {
        return this.getBoolean(this.indexOf(name), trueValue);
    }

    @Override
    public byte getByte(String name) {
        int index = this.indexOf(name);
        return index == -1 ? (byte)0 : this.getByte(index);
    }

    @Override
    public byte getByte(int index) {
        Byte b = this.convert(this.values.get(index), Byte.class);
        return b != null ? b : (byte)0;
    }

    @Override
    public byte getByte(String name, byte defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getByte(index, defaultValue);
    }

    @Override
    public byte getByte(int index, byte defaultValue) {
        Byte b = this.convert(this.values.get(index), Byte.class);
        return b != null ? b : defaultValue;
    }

    @Override
    public short getShort(String name) {
        int index = this.indexOf(name);
        return index == -1 ? (short)0 : this.getShort(index);
    }

    @Override
    public short getShort(int index) {
        Short s = this.convert(this.values.get(index), Short.class);
        return s != null ? s : (short)0;
    }

    @Override
    public short getShort(String name, short defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getShort(index, defaultValue);
    }

    @Override
    public short getShort(int index, short defaultValue) {
        Short s = this.convert(this.values.get(index), Short.class);
        return s != null ? s : defaultValue;
    }

    @Override
    public int getInt(String name) {
        int index = this.indexOf(name);
        return index == -1 ? 0 : this.getInt(index);
    }

    @Override
    public int getInt(int index) {
        Integer i = this.convert(this.values.get(index), Integer.class);
        return i != null ? i : 0;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getInt(index, defaultValue);
    }

    @Override
    public int getInt(int index, int defaultValue) {
        Integer i = this.convert(this.values.get(index), Integer.class);
        return i != null ? i : defaultValue;
    }

    @Override
    public long getLong(String name) {
        int index = this.indexOf(name);
        return index == -1 ? 0L : this.getLong(index);
    }

    @Override
    public long getLong(int index) {
        Long l = this.convert(this.values.get(index), Long.class);
        return l != null ? l : 0L;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getLong(index, defaultValue);
    }

    @Override
    public long getLong(int index, long defaultValue) {
        Long l = this.convert(this.values.get(index), Long.class);
        return l != null ? l : defaultValue;
    }

    @Override
    public float getFloat(String name) {
        int index = this.indexOf(name);
        return index == -1 ? 0.0f : this.getFloat(index);
    }

    @Override
    public float getFloat(int index) {
        Float f = this.convert(this.values.get(index), Float.class);
        return f != null ? f.floatValue() : 0.0f;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getFloat(index, defaultValue);
    }

    @Override
    public float getFloat(int index, float defaultValue) {
        Float f = this.convert(this.values.get(index), Float.class);
        return f != null ? f.floatValue() : defaultValue;
    }

    @Override
    public double getDouble(String name) {
        int index = this.indexOf(name);
        return index == -1 ? 0.0 : this.getDouble(index);
    }

    @Override
    public double getDouble(int index) {
        Double d = this.convert(this.values.get(index), Double.class);
        return d != null ? d : 0.0;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getDouble(index, defaultValue);
    }

    @Override
    public double getDouble(int index, double defaultValue) {
        Double d = this.convert(this.values.get(index), Double.class);
        return d != null ? d : defaultValue;
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(this.indexOf(name));
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.convert(this.values.get(index), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getBigDecimal(index, defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(int index, BigDecimal defaultValue) {
        BigDecimal bd = this.convert(this.values.get(index), BigDecimal.class);
        return bd != null ? bd : defaultValue;
    }

    @Override
    public Date getDate(int index) {
        return this.convert(this.values.get(index), Date.class);
    }

    @Override
    public Date getDate(String name) {
        return this.getDate(this.indexOf(name));
    }

    @Override
    public Date getDate(String name, Date defaultValue) {
        int index = this.indexOf(name);
        return index == -1 ? defaultValue : this.getDate(index, defaultValue);
    }

    @Override
    public Date getDate(int index, Date defaultValue) {
        Date d = this.getDate(index);
        return d != null ? d : defaultValue;
    }

    @Override
    public Date getDateWithPattern(int index, String pattern) {
        StringToDateConverter converter = new StringToDateConverter(pattern);
        return converter.convert(this.readAndTrim(index));
    }

    @Override
    public Date getDateWithPattern(String name, String pattern) {
        try {
            return this.getDateWithPattern(this.indexOf(name), pattern);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public Date getDateWithPattern(int index, String pattern, Date defaultValue) {
        try {
            Date d = this.getDateWithPattern(index, pattern);
            return d != null ? d : defaultValue;
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    @Override
    public Date getDateWithPattern(String name, String pattern, Date defaultValue) {
        try {
            return this.getDateWithPattern(this.indexOf(name), pattern, defaultValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage() + ", name: [" + name + "]");
        }
    }

    @Override
    public <T> T getValue(String name, Class<T> valueClass) {
        Object value = this.values.get(this.indexOf(name));
        return this.convert(value, valueClass);
    }

    @Override
    public <T> T getValue(int index, Class<T> valueClass) {
        return this.convert(this.values.get(index), valueClass);
    }

    @Override
    public Tuple select(String expression) {
        StandardEvaluationContext context = new StandardEvaluationContext(this.toMap());
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(expression);
        Object result = exp.getValue((EvaluationContext)context);
        Map resultMap = null;
        if (ClassUtils.isAssignableValue(Map.class, (Object)result)) {
            resultMap = (Map)result;
        }
        if (resultMap != null) {
            return this.toTuple(resultMap);
        }
        return new DefaultTuple(new ArrayList<String>(0), new ArrayList<Object>(0), this.configurableConversionService);
    }

    Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            map.put(this.names.get(i), this.values.get(i));
        }
        return map;
    }

    Tuple toTuple(Map<String, Object> resultMap) {
        ArrayList<String> newNames = new ArrayList<String>();
        ArrayList<Object> newValues = new ArrayList<Object>();
        for (String name : resultMap.keySet()) {
            newNames.add(name);
        }
        for (Object value : resultMap.values()) {
            newValues.add(value);
        }
        return new DefaultTuple(newNames, newValues, this.configurableConversionService);
    }

    <T> T convert(Object value, Class<T> targetType) {
        return (T)this.configurableConversionService.convert(value, TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(targetType));
    }

    protected int indexOf(String name) {
        return this.names.indexOf(name);
    }

    protected void setTupleToStringConverter(Converter<Tuple, String> tupleToStringConverter) {
        Assert.notNull(tupleToStringConverter, (String)"tupleToStringConverter cannot be null");
        this.tupleToStringConverter = tupleToStringConverter;
    }

    public String toString() {
        return (String)this.tupleToStringConverter.convert((Object)this);
    }

    public ConfigurableConversionService getConversionService() {
        return this.configurableConversionService;
    }
}

