/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.rest.domain.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public final class TimeUtils {
    public static final String DEFAULT_XD_DATE_FORMAT_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_XD_TIME_FORMAT_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_XD_DATE_TIME_FORMAT_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    public static final String DEFAULT_XD_DURATION_FORMAT_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_XD_TIMEZONE_ID = "UTC";

    private TimeUtils() {
        throw new AssertionError();
    }

    public static TimeZone getDefaultTimeZone() {
        return TimeZone.getTimeZone(DEFAULT_XD_TIMEZONE_ID);
    }

    public static TimeZone getJvmTimeZone() {
        return TimeZone.getDefault();
    }

    public static DateFormat getDefaultDateFormat() {
        return new SimpleDateFormat(DEFAULT_XD_DATE_FORMAT_PATTERN);
    }

    public static DateFormat getDefaultTimeFormat() {
        return new SimpleDateFormat("HH:mm:ss");
    }

    public static DateFormat getDefaultDateTimeFormat() {
        return new SimpleDateFormat(DEFAULT_XD_DATE_TIME_FORMAT_PATTERN);
    }

    public static DateFormat getDefaultDurationFormat() {
        return new SimpleDateFormat("HH:mm:ss");
    }
}

