/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.rest.domain.support;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class DeploymentPropertiesFormat {
    private static final Pattern DEPLOYMENT_PROPERTIES_PATTERN = Pattern.compile(",\\s*module\\.[^\\.]+\\.[^=]+=");

    private DeploymentPropertiesFormat() {
    }

    public static Map<String, String> parseDeploymentProperties(String s) {
        HashMap<String, String> deploymentProperties = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)s)) {
            Matcher matcher = DEPLOYMENT_PROPERTIES_PATTERN.matcher(s);
            int start = 0;
            while (matcher.find()) {
                DeploymentPropertiesFormat.addKeyValuePairAsProperty(s.substring(start, matcher.start()), deploymentProperties);
                start = matcher.start() + 1;
            }
            DeploymentPropertiesFormat.addKeyValuePairAsProperty(s.substring(start), deploymentProperties);
        }
        return deploymentProperties;
    }

    public static String formatDeploymentProperties(Map<String, String> properties) {
        StringBuilder sb = new StringBuilder(15 * properties.size());
        for (Map.Entry<String, String> pair : properties.entrySet()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(pair.getKey()).append("=").append(pair.getValue());
        }
        return sb.toString();
    }

    private static void addKeyValuePairAsProperty(String pair, Map<String, String> properties) {
        int firstEquals = pair.indexOf(61);
        if (firstEquals != -1) {
            properties.put(pair.substring(0, firstEquals).trim(), pair.substring(firstEquals + 1).trim());
        }
    }

    public static Map<String, String> convert(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (String key : properties.stringPropertyNames()) {
            result.put(key, properties.getProperty(key));
        }
        return result;
    }
}

