/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.rest.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlRootElement;
import org.springframework.batch.admin.web.JobParametersExtractor;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.xd.rest.domain.util.TimeUtils;

@XmlRootElement
public class JobExecutionInfoResource
extends ResourceSupport {
    private DateFormat dateFormat = TimeUtils.getDefaultDateFormat();
    private DateFormat timeFormat = TimeUtils.getDefaultTimeFormat();
    private DateFormat durationFormat = TimeUtils.getDefaultDurationFormat();
    private Long executionId;
    private int stepExecutionCount;
    private Long jobId;
    @JsonProperty(value="name")
    private String jobName;
    private String startDate = "";
    private String startTime = "";
    private String duration = "";
    private JobExecution jobExecution;
    private Properties jobParameters;
    private String jobParametersString;
    private boolean restartable = false;
    private boolean abandonable = false;
    private boolean stoppable = false;
    private boolean deployed = true;
    private boolean deleted = false;
    private boolean composedJob = false;
    private JobParametersConverter converter = new DefaultJobParametersConverter();
    private final TimeZone timeZone;
    final List<JobExecutionInfoResource> childJobExecutions = new ArrayList<JobExecutionInfoResource>(0);

    public JobExecutionInfoResource() {
        this.timeZone = TimeUtils.getDefaultTimeZone();
    }

    public JobExecutionInfoResource(JobExecution jobExecution, TimeZone timeZone) {
        this.jobExecution = jobExecution;
        this.timeZone = timeZone;
        this.executionId = jobExecution.getId();
        this.jobId = jobExecution.getJobId();
        this.stepExecutionCount = jobExecution.getStepExecutions().size();
        this.jobParameters = this.converter.getProperties(jobExecution.getJobParameters());
        this.jobParametersString = new JobParametersExtractor().fromJobParameters(jobExecution.getJobParameters());
        JobInstance jobInstance = jobExecution.getJobInstance();
        if (jobInstance != null) {
            this.jobName = jobInstance.getJobName();
            BatchStatus status = jobExecution.getStatus();
            this.restartable = status.isGreaterThan(BatchStatus.STOPPING) && status.isLessThan(BatchStatus.ABANDONED);
            this.abandonable = status.isGreaterThan(BatchStatus.STARTED) && status != BatchStatus.ABANDONED;
            this.stoppable = status.isLessThan(BatchStatus.STOPPING) && status != BatchStatus.COMPLETED;
        } else {
            this.jobName = "?";
        }
        this.durationFormat.setTimeZone(TimeUtils.getDefaultTimeZone());
        this.timeFormat.setTimeZone(timeZone);
        this.dateFormat.setTimeZone(timeZone);
        if (jobExecution.getStartTime() != null) {
            this.startDate = this.dateFormat.format(jobExecution.getStartTime());
            this.startTime = this.timeFormat.format(jobExecution.getStartTime());
            Date endTime = jobExecution.getEndTime() != null ? jobExecution.getEndTime() : new Date();
            this.duration = this.durationFormat.format(new Date(endTime.getTime() - jobExecution.getStartTime().getTime()));
        }
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @JsonProperty
    public String getName() {
        return this.jobName.endsWith(".job") ? this.jobName.substring(0, this.jobName.lastIndexOf(".job")) : this.jobName;
    }

    public Long getExecutionId() {
        return this.executionId;
    }

    public int getStepExecutionCount() {
        return this.stepExecutionCount;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public JobExecution getJobExecution() {
        return this.jobExecution;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isAbandonable() {
        return this.abandonable;
    }

    public boolean isStoppable() {
        return this.stoppable;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getJobParametersString() {
        return this.jobParametersString;
    }

    public Properties getJobParameters() {
        return this.jobParameters;
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setDeployed(boolean deployed) {
        this.deployed = deployed;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isComposedJob() {
        return this.composedJob;
    }

    public void setComposedJob(boolean composedJob) {
        this.composedJob = composedJob;
    }

    public List<JobExecutionInfoResource> getChildJobExecutions() {
        return this.childJobExecutions;
    }

    public static class Page
    extends PagedResources<JobExecutionInfoResource> {
    }
}

