/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.util.Assert;

public class DateTrigger
implements Trigger {
    private final List<Date> nextFireDates = new ArrayList<Date>();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DateTrigger(Date ... dates) {
        for (Date date : dates) {
            this.addDate(date);
        }
        Collections.sort(this.nextFireDates);
    }

    public Date nextExecutionTime(TriggerContext triggerContext) {
        Date result = null;
        if (this.nextFireDates.size() > 0) {
            try {
                result = this.nextFireDates.remove(0);
            }
            catch (IndexOutOfBoundsException e) {
                this.logger.debug(e.getMessage());
            }
        }
        return result;
    }

    private void addDate(Date date) {
        Assert.notNull((Object)date, (String)"Date must not be null");
        this.nextFireDates.add(date);
    }
}

