/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

public class ModuleOption {
    private final String name;
    private final String description;
    private Object defaultValue;
    private boolean hidden = false;
    private String type;

    public ModuleOption(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public ModuleOption withType(Class<?> type) {
        if (type != null) {
            this.type = type.getCanonicalName();
        }
        return this;
    }

    public ModuleOption withType(String type) {
        this.type = type;
        return this;
    }

    public ModuleOption withDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ModuleOption hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleOption that = (ModuleOption)o;
        if (this.hidden != that.hidden) {
            return false;
        }
        if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + (this.hidden ? 1 : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ModuleOption [name=" + this.name + ", type=" + this.type + ", defaultValue=" + this.defaultValue + ", description=" + this.description + "]";
    }
}

