/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.options.FlattenedCompositeModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadata;
import org.springframework.xd.module.options.ModuleOptionsMetadataResolver;

public class DelegatingModuleOptionsMetadataResolver
implements ModuleOptionsMetadataResolver {
    private List<ModuleOptionsMetadataResolver> delegates;

    public void setDelegates(List<ModuleOptionsMetadataResolver> delegates) {
        Assert.notEmpty(delegates, (String)"at least one delegate resolver is required");
        this.delegates = delegates;
    }

    @Override
    public ModuleOptionsMetadata resolve(ModuleDefinition moduleDefinition) {
        ArrayList<ModuleOptionsMetadata> moms = new ArrayList<ModuleOptionsMetadata>(this.delegates.size());
        for (ModuleOptionsMetadataResolver delegate : this.delegates) {
            ModuleOptionsMetadata resolved = delegate.resolve(moduleDefinition);
            if (resolved == null) continue;
            moms.add(resolved);
        }
        return new FlattenedCompositeModuleOptionsMetadata(moms);
    }
}

