/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.info;

import java.util.Properties;
import org.springframework.boot.bind.PropertiesConfigurationFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.CustomValidatorBean;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.info.ModuleInformation;
import org.springframework.xd.module.info.ModuleInformationResolver;
import org.springframework.xd.module.options.ModuleUtils;

public class DefaultSimpleModuleInformationResolver
implements ModuleInformationResolver {
    private CustomValidatorBean validator = new CustomValidatorBean();

    public DefaultSimpleModuleInformationResolver() {
        this.validator.afterPropertiesSet();
    }

    @Override
    public ModuleInformation resolve(ModuleDefinition definition) {
        if (!(definition instanceof SimpleModuleDefinition)) {
            return null;
        }
        SimpleModuleDefinition simpleModuleDefinition = (SimpleModuleDefinition)definition;
        Properties props = ModuleUtils.loadModuleProperties(simpleModuleDefinition);
        if (props == null) {
            return null;
        }
        try {
            ModuleInformation result = new ModuleInformation();
            PropertiesConfigurationFactory factory = new PropertiesConfigurationFactory((Object)result);
            factory.setProperties(props);
            factory.setTargetName("info");
            factory.setValidator((Validator)this.validator);
            factory.bindPropertiesToTarget();
            return result;
        }
        catch (BindException e) {
            throw new RuntimeException("Exception occurred trying to set values from properties file for " + definition + "\n" + e.getMessage(), e);
        }
    }
}

