/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ModuleEnvironment
extends AbstractEnvironment {
    private ConfigurableEnvironment parent;

    public ModuleEnvironment(EnumerablePropertySource<?> moduleOptionsPropertySource, ConfigurableEnvironment parent) {
        this.parent = parent;
        if (parent != null) {
            this.merge(parent);
        }
        this.clearPropertySources();
        this.getPropertySources().addFirst(this.wrap(moduleOptionsPropertySource));
    }

    private EnumerablePropertySource<?> wrap(final EnumerablePropertySource<?> moduleOptionsPropertySource) {
        return new EnumerablePropertySource<Object>(moduleOptionsPropertySource.getName(), moduleOptionsPropertySource){

            public String[] getPropertyNames() {
                return moduleOptionsPropertySource.getPropertyNames();
            }

            public Object getProperty(String name) {
                Object result = moduleOptionsPropertySource.getProperty(name);
                if (result != null) {
                    return result;
                }
                if (moduleOptionsPropertySource.containsProperty(name)) {
                    return null;
                }
                return ModuleEnvironment.this.parent == null ? null : ModuleEnvironment.this.parent.getProperty(name);
            }
        };
    }

    private void clearPropertySources() {
        ArrayList<String> names = new ArrayList<String>();
        for (PropertySource ps : this.getPropertySources()) {
            names.add(ps.getName());
        }
        for (String name : names) {
            this.getPropertySources().remove(name);
        }
        Map empty = Collections.emptyMap();
        this.getPropertySources().addLast((PropertySource)new MapPropertySource("systemProperties", empty));
        this.getPropertySources().addLast((PropertySource)new MapPropertySource("systemEnvironment", empty));
    }
}

