/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.SimpleModuleDefinition;
import org.springframework.xd.module.core.SimpleModule;
import org.springframework.xd.module.options.ModuleOptions;
import org.springframework.xd.module.options.ModuleUtils;

public class JavaConfiguredModule
extends SimpleModule {
    private static final String BASE_PACKAGES = "base_packages";

    public JavaConfiguredModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties) {
        super(descriptor, deploymentProperties);
    }

    public JavaConfiguredModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties, ClassLoader classLoader, ModuleOptions moduleOptions) {
        super(descriptor, deploymentProperties, classLoader, moduleOptions);
    }

    @Override
    protected void configureModuleApplicationContext(SimpleModuleDefinition moduleDefinition) {
        Object[] basePackages = JavaConfiguredModule.basePackages(moduleDefinition);
        Assert.notEmpty((Object[])basePackages, (String)String.format("%s property does not exist or does not contain a value for module %s.", BASE_PACKAGES, moduleDefinition.toString()));
        this.addListener(new JavaConfigModuleListener((String[])basePackages));
        this.addListener(new JavaConfigValidationListener(moduleDefinition, (String[])basePackages));
    }

    public static String[] basePackages(SimpleModuleDefinition moduleDefinition) {
        Properties properties = ModuleUtils.loadModuleProperties(moduleDefinition);
        if (properties == null) {
            return new String[0];
        }
        String basePackageNames = properties.getProperty(BASE_PACKAGES);
        return StringUtils.commaDelimitedListToStringArray((String)basePackageNames);
    }

    static class JavaConfigValidationListener
    implements ApplicationListener<ContextRefreshedEvent> {
        private final ModuleDefinition moduleDefinition;
        private final String[] basePackages;

        public JavaConfigValidationListener(SimpleModuleDefinition moduleDefinition, String[] basePackages) {
            this.basePackages = Arrays.copyOf(basePackages, basePackages.length);
            this.moduleDefinition = moduleDefinition;
        }

        public void onApplicationEvent(ContextRefreshedEvent event) {
            ApplicationContext context = event.getApplicationContext();
            Map moduleConfiguration = context.getBeansWithAnnotation(Configuration.class);
            boolean found = false;
            if (!CollectionUtils.isEmpty((Map)moduleConfiguration)) {
                for (String pkg : this.basePackages) {
                    if (found) break;
                    for (Object obj : moduleConfiguration.values()) {
                        if (!obj.getClass().getName().startsWith(pkg)) continue;
                        found = true;
                    }
                }
            }
            if (!found) {
                throw new RuntimeException(String.format("Unable to find a module @Configuration class in base_packages: %s for module %s:%s", new Object[]{StringUtils.arrayToCommaDelimitedString((Object[])this.basePackages), this.moduleDefinition.getName(), this.moduleDefinition.getType()}));
            }
        }
    }

    static class JavaConfigModuleListener
    implements ApplicationListener<ApplicationPreparedEvent> {
        private final String[] basePackages;

        public JavaConfigModuleListener(String ... basePackages) {
            this.basePackages = basePackages;
        }

        public void onApplicationEvent(ApplicationPreparedEvent event) {
            AnnotationConfigApplicationContext context = (AnnotationConfigApplicationContext)event.getApplicationContext();
            context.scan(this.basePackages);
        }
    }
}

