/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.util.Assert;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;
import org.springframework.xd.module.ModuleType;
import org.springframework.xd.module.core.AbstractModule;
import org.springframework.xd.module.core.Module;

public class CompositeModule
extends AbstractModule {
    public static final String OPTION_SEPARATOR = ".";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GenericApplicationContext context = new GenericApplicationContext();
    private final List<Module> modules;
    private final Properties properties = new Properties();
    private final AtomicInteger propertiesCounter = new AtomicInteger();
    private final AtomicBoolean isRunning = new AtomicBoolean();

    public CompositeModule(ModuleDescriptor descriptor, ModuleDeploymentProperties deploymentProperties, List<Module> modules) {
        super(descriptor, deploymentProperties);
        this.modules = modules;
        this.validate();
    }

    private void validate() {
        Assert.isTrue((this.modules != null && this.modules.size() > 0 ? 1 : 0) != 0, (String)"at least one module required");
        ModuleType inferredType = null;
        if (this.modules.size() == 1) {
            inferredType = this.modules.get(0).getType();
        } else {
            boolean hasOutput;
            ModuleType firstType = this.modules.get(0).getType();
            ModuleType lastType = this.modules.get(this.modules.size() - 1).getType();
            boolean hasInput = firstType != ModuleType.source;
            boolean bl = hasOutput = lastType != ModuleType.sink;
            if (hasInput && hasOutput) {
                inferredType = ModuleType.processor;
            } else if (hasInput) {
                inferredType = ModuleType.sink;
            } else if (hasOutput) {
                inferredType = ModuleType.source;
            }
        }
        Assert.isTrue((inferredType == this.getType() ? 1 : 0) != 0, (String)("invalid composite module: inferred type=" + (Object)((Object)inferredType) + ", stated type=" + (Object)((Object)this.getType())));
    }

    @Override
    public void initialize() {
        int i;
        ArrayList<AbstractEndpoint> endpoints = new ArrayList<AbstractEndpoint>();
        MessageChannel previousOutputChannel = null;
        for (i = 0; i < this.modules.size(); ++i) {
            Module module = this.modules.get(i);
            module.initialize();
            MessageChannel inputChannel = module.getComponent("input", MessageChannel.class);
            MessageChannel outputChannel = module.getComponent("output", MessageChannel.class);
            if (i == 0 && inputChannel != null) {
                this.context.getBeanFactory().registerSingleton("input", (Object)inputChannel);
            }
            if (i > 0) {
                Assert.notNull((Object)inputChannel, (String)"each module after the first must provide 'input'");
            }
            if (previousOutputChannel != null) {
                BridgeHandler handler = new BridgeHandler();
                handler.setBeanFactory((BeanFactory)this.context.getBeanFactory());
                handler.setOutputChannel(inputChannel);
                handler.afterPropertiesSet();
                ConsumerEndpointFactoryBean bridgeFactoryBean = new ConsumerEndpointFactoryBean();
                bridgeFactoryBean.setInputChannel(previousOutputChannel);
                bridgeFactoryBean.setHandler((MessageHandler)handler);
                try {
                    bridgeFactoryBean.setBeanFactory((BeanFactory)this.context.getBeanFactory());
                    String beanName = "bridge-" + i;
                    bridgeFactoryBean.setBeanName(beanName);
                    bridgeFactoryBean.afterPropertiesSet();
                    AbstractEndpoint endpoint = bridgeFactoryBean.getObject();
                    endpoints.add(endpoint);
                    this.context.getBeanFactory().registerSingleton(beanName, (Object)endpoint);
                    endpoint.setComponentName(beanName);
                    endpoint.afterPropertiesSet();
                }
                catch (Exception e) {
                    throw new IllegalStateException("failed to start bridge for CompositeModule", e);
                }
            }
            if (i < this.modules.size() - 1) {
                Assert.notNull((Object)outputChannel, (String)"each module before the last must provide 'output'");
            }
            previousOutputChannel = outputChannel;
            if (i != this.modules.size() - 1 || outputChannel == null) continue;
            this.context.getBeanFactory().registerSingleton("output", (Object)outputChannel);
        }
        for (i = endpoints.size() - 1; i >= 0; --i) {
            ((AbstractEndpoint)endpoints.get(i)).start();
        }
        this.initContext();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("initialized module: " + this.toString());
        }
    }

    @Override
    public ConfigurableApplicationContext getApplicationContext() {
        return this.context;
    }

    private void initContext() {
        Assert.state((this.context != null ? 1 : 0) != 0, (String)"An ApplicationContext is required");
        boolean propertyConfigurerPresent = false;
        for (String name : this.context.getBeanDefinitionNames()) {
            if (!name.startsWith("org.springframework.context.support.PropertySourcesPlaceholderConfigurer")) continue;
            propertyConfigurerPresent = true;
            break;
        }
        if (!propertyConfigurerPresent) {
            PropertySourcesPlaceholderConfigurer placeholderConfigurer = new PropertySourcesPlaceholderConfigurer();
            placeholderConfigurer.setEnvironment((Environment)this.context.getEnvironment());
            this.context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)placeholderConfigurer);
        }
        this.context.setId(this.toString());
        this.context.refresh();
    }

    @Override
    public void setParentContext(ApplicationContext parentContext) {
        this.context.setParent(parentContext);
        for (Module module : this.modules) {
            module.setParentContext(parentContext);
        }
    }

    @Override
    public void addListener(ApplicationListener<?> listener) {
        for (Module module : this.modules) {
            module.addListener(listener);
        }
    }

    @Override
    public void addSource(Object source) {
        Assert.notNull((Object)source, (String)"source cannot be null");
        Assert.isInstanceOf(Resource.class, (Object)source, (String)("unsupported source: " + source.getClass().getName()));
        Resource resource = (Resource)source;
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.context);
        reader.loadBeanDefinitions(resource);
    }

    @Override
    public void addProperties(Properties properties) {
        this.registerPropertySource(properties);
        this.properties.putAll((Map<?, ?>)properties);
        for (Module module : this.modules) {
            module.addProperties(properties);
        }
    }

    private void registerPropertySource(Properties properties) {
        int propertiesIndex = this.propertiesCounter.getAndIncrement();
        String propertySourceName = "properties-" + propertiesIndex;
        PropertiesPropertySource propertySource = new PropertiesPropertySource(propertySourceName, properties);
        this.context.getEnvironment().getPropertySources().addLast((PropertySource)propertySource);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public <T> T getComponent(Class<T> requiredType) {
        return (T)(this.context.isActive() ? this.context.getBean(requiredType) : null);
    }

    @Override
    public <T> T getComponent(String componentName, Class<T> requiredType) {
        if (this.context.isActive() && this.context.containsBean(componentName)) {
            return (T)this.context.getBean(componentName, requiredType);
        }
        return null;
    }

    @Override
    public void destroy() {
        for (Module module : this.modules) {
            module.destroy();
        }
        if (this.context != null) {
            this.context.destroy();
        }
    }

    public void start() {
        Assert.state((this.context != null ? 1 : 0) != 0, (String)"An ApplicationContext is required");
        if (this.isRunning.compareAndSet(false, true)) {
            for (int i = this.modules.size() - 1; i >= 0; --i) {
                Module module = this.modules.get(i);
                module.start();
            }
            try {
                this.context.start();
            }
            catch (BeansException be) {
                this.context.destroy();
                throw be;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("started module: " + this.toString());
            }
        }
    }

    public void stop() {
        if (this.isRunning.compareAndSet(true, false)) {
            for (Module module : this.modules) {
                module.stop();
            }
            this.context.stop();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("stopped module: " + this.toString());
            }
        }
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

