/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.validation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.springframework.beans.BeanWrapperImpl;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Constraint(validatedBy={DateWithCustomFormatValidator.class})
public @interface DateWithCustomFormat {
    public static final String DEFAULT_MESSAGE = "";

    public String message() default "";

    public String dateProperty() default "date";

    public String formatProperty() default "dateFormat";

    public Class<?>[] groups() default {};

    public Class<? extends Payload>[] payload() default {};

    public static class DateWithCustomFormatValidator
    implements ConstraintValidator<DateWithCustomFormat, Object> {
        private String dateProperty;
        private String formatProperty;
        private String message;

        public void initialize(DateWithCustomFormat constraintAnnotation) {
            this.dateProperty = constraintAnnotation.dateProperty();
            this.formatProperty = constraintAnnotation.formatProperty();
            this.message = constraintAnnotation.message();
        }

        public boolean isValid(Object value, ConstraintValidatorContext context) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
            String date = (String)beanWrapper.getPropertyValue(this.dateProperty);
            String format = (String)beanWrapper.getPropertyValue(this.formatProperty);
            if (date == null || format == null) {
                return true;
            }
            SimpleDateFormat sdf = null;
            try {
                sdf = new SimpleDateFormat(format);
                sdf.setLenient(false);
            }
            catch (IllegalArgumentException e) {
                return true;
            }
            try {
                sdf.parse(date);
            }
            catch (ParseException e) {
                if (DateWithCustomFormat.DEFAULT_MESSAGE.equals(this.message)) {
                    context.disableDefaultConstraintViolation();
                    String message = String.format("Can not be parsed as a date using the format specified in '%s', that is, '%s'", this.formatProperty, format);
                    context.buildConstraintViolationWithTemplate(message).addPropertyNode(this.dateProperty).addConstraintViolation();
                }
                return false;
            }
            return true;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface List {
        public DateWithCustomFormat[] value();
    }
}

