/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.module.options.mixins;

import org.springframework.xd.module.options.mixins.MaxMessagesDefaultOneMixin;
import org.springframework.xd.module.options.mixins.MongoDbConnectionMixin;
import org.springframework.xd.module.options.mixins.PeriodicTriggerMixin;
import org.springframework.xd.module.options.spi.Mixin;
import org.springframework.xd.module.options.spi.ModuleOption;
import org.springframework.xd.module.options.spi.ProfileNamesProvider;

public abstract class FromMongoDbOptionMixin
implements ProfileNamesProvider {
    private static final String[] USE_SPLITTER = new String[]{"use-splitter"};
    private static final String[] DONT_USE_SPLITTER = new String[]{"dont-use-splitter"};
    private String query = "{}";
    private String collectionName;
    private int fixedDelay = 1000;
    private boolean split = true;

    protected FromMongoDbOptionMixin(String collectionName) {
        this.collectionName = collectionName;
    }

    @ModuleOption(value="the MongoDB collection to read from")
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @ModuleOption(value="the time delay between polls for data, expressed in TimeUnits (seconds by default)")
    public void setFixedDelay(int fixedDelay) {
        this.fixedDelay = fixedDelay;
    }

    @ModuleOption(value="the query to make to the mongo db")
    public void setQuery(String query) {
        this.query = query;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public int getFixedDelay() {
        return this.fixedDelay;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isSplit() {
        return this.split;
    }

    @ModuleOption(value="whether to split the query result as individual messages")
    public void setSplit(boolean split) {
        this.split = split;
    }

    @Override
    public String[] profilesToActivate() {
        return this.split ? USE_SPLITTER : DONT_USE_SPLITTER;
    }

    @Mixin(value={MongoDbConnectionMixin.class, PeriodicTriggerMixin.class, MaxMessagesDefaultOneMixin.class})
    public static class Stream
    extends FromMongoDbOptionMixin {
        public Stream() {
            super("${xd.stream.name}");
        }
    }

    @Mixin(value={MongoDbConnectionMixin.class, PeriodicTriggerMixin.class, MaxMessagesDefaultOneMixin.class})
    public static class Job
    extends FromMongoDbOptionMixin {
        public Job() {
            super("${xd.job.name}");
        }
    }
}

