/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.zookeeper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.slf4j.Logger;
import org.springframework.core.convert.converter.Converter;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperAccessException;

public abstract class ZooKeeperUtils {
    private static final MapBytesUtility mapBytesUtility = new MapBytesUtility();
    public static final StripPathConverter stripPathConverter = new StripPathConverter();

    public static byte[] mapToBytes(Map<String, String> map) {
        return ZooKeeperUtils.mapBytesUtility.toByteArray(map);
    }

    public static Map<String, String> bytesToMap(byte[] bytes) {
        return ZooKeeperUtils.mapBytesUtility.toMap(bytes);
    }

    public static RuntimeException wrapThrowable(Throwable t) {
        return ZooKeeperUtils.wrapThrowable(t, null);
    }

    public static RuntimeException wrapThrowable(Throwable t, String message) {
        if (message != null) {
            return new ZooKeeperAccessException(message, t);
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new ZooKeeperAccessException(t.getMessage(), t);
    }

    public static void wrapAndThrowIgnoring(Throwable t, Class ... ignored) {
        if (ignored != null) {
            for (Class e : ignored) {
                if (!e.isAssignableFrom(t.getClass())) continue;
                return;
            }
        }
        throw ZooKeeperUtils.wrapThrowable(t);
    }

    public static void logCacheEvent(Logger logger, PathChildrenCacheEvent event) {
        ChildData data = event.getData();
        StringBuilder builder = new StringBuilder();
        builder.append("Path cache event: ");
        if (data != null && data.getPath() != null) {
            builder.append("path=").append(data.getPath()).append(", ");
        }
        builder.append("type=").append(event.getType());
        if (EnumSet.of(PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED, PathChildrenCacheEvent.Type.CONNECTION_LOST).contains(event.getType())) {
            logger.warn(builder.toString());
        } else {
            logger.info(builder.toString());
        }
        if (data != null && logger.isTraceEnabled()) {
            String content;
            byte[] bytes = data.getData();
            if (bytes == null || bytes.length == 0) {
                content = "empty";
            } else {
                try {
                    content = new String(data.getData(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    content = "Could not convert content to UTF-8: " + e.toString();
                }
            }
            logger.trace("Data for path {}: {}", (Object)data.getPath(), (Object)content);
        }
    }

    public static String getStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private static class MapBytesUtility {
        private final ObjectWriter writer;
        private final ObjectReader reader;

        private MapBytesUtility() {
            ObjectMapper mapper = new ObjectMapper();
            this.writer = mapper.writer();
            this.reader = mapper.reader(Map.class);
        }

        private byte[] toByteArray(Map<String, String> map) {
            try {
                return this.writer.writeValueAsBytes(map);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<String, String> toMap(byte[] bytes) {
            if (bytes == null || bytes.length == 0) {
                return Collections.emptyMap();
            }
            try {
                return (Map)this.reader.readValue(bytes);
            }
            catch (Exception e) {
                String contents;
                try {
                    contents = new String(bytes, "UTF-8");
                }
                catch (UnsupportedEncodingException uue) {
                    contents = "Could not read content due to " + uue;
                }
                throw new RuntimeException("Error parsing JSON string: " + contents, e);
            }
        }
    }

    public static class StripPathConverter
    implements Converter<ChildData, String> {
        public String convert(ChildData source) {
            return Paths.stripPath(source.getPath());
        }
    }
}

