/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.zookeeper;

import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnectionListener;

public class ZooKeeperConnection
implements SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperConnection.class);
    public static final String DEFAULT_CLIENT_CONNECT_STRING = "localhost:2181";
    public static final int DEFAULT_SESSION_TIMEOUT = 60000;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_INITIAL_RETRY_WAIT = 1000;
    public static final int DEFAULT_MAX_RETRY_ATTEMPTS = 3;
    private volatile CuratorFramework curatorFramework;
    private volatile RetryPolicy retryPolicy;
    private final DelegatingConnectionStateListener connectionListener = new DelegatingConnectionStateListener();
    private final CopyOnWriteArraySet<ZooKeeperConnectionListener> listeners = new CopyOnWriteArraySet();
    private volatile boolean running;
    private volatile boolean autoStartup = true;
    private volatile ConnectionState currentState;
    private final String clientConnectString;
    private final String namespace;
    private final int sessionTimeout;
    private final int connectionTimeout;

    public ZooKeeperConnection() {
        this(DEFAULT_CLIENT_CONNECT_STRING, null);
    }

    public ZooKeeperConnection(String clientConnectString) {
        this(clientConnectString, null);
    }

    public ZooKeeperConnection(String clientConnectString, String namespace) {
        this(clientConnectString, namespace, 60000, 30000, 1000, 3);
    }

    public ZooKeeperConnection(String clientConnectString, String namespace, int sessionTimeout, int connectionTimeout, int initialRetryWait, int retryMaxAttempts) {
        Assert.hasText((String)clientConnectString, (String)"clientConnectString is required");
        this.clientConnectString = clientConnectString;
        this.namespace = StringUtils.hasText((String)namespace) ? namespace : "xd";
        this.sessionTimeout = sessionTimeout;
        this.connectionTimeout = connectionTimeout;
        this.retryPolicy = new ExponentialBackoffRetry(initialRetryWait, retryMaxAttempts);
    }

    public boolean isConnected() {
        return this.currentState == ConnectionState.CONNECTED || this.currentState == ConnectionState.RECONNECTED;
    }

    public CuratorFramework getClient() {
        return this.curatorFramework;
    }

    public boolean addListener(ZooKeeperConnectionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(ZooKeeperConnectionListener listener) {
        return this.listeners.remove(listener);
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        Assert.notNull((Object)retryPolicy, (String)"retryPolicy cannot be null");
        this.retryPolicy = retryPolicy;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        if (!this.running) {
            this.curatorFramework = CuratorFrameworkFactory.builder().defaultData(new byte[0]).namespace(this.namespace).retryPolicy(this.retryPolicy).connectString(this.clientConnectString).sessionTimeoutMs(this.sessionTimeout).connectionTimeoutMs(this.connectionTimeout).build();
            this.curatorFramework.getConnectionStateListenable().addListener((Object)this.connectionListener);
            this.curatorFramework.start();
            this.running = true;
        }
    }

    public synchronized void stop() {
        if (this.running) {
            if (this.currentState != null) {
                this.curatorFramework.close();
            }
            this.running = false;
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    private class DelegatingConnectionStateListener
    implements ConnectionStateListener {
        private DelegatingConnectionStateListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            ZooKeeperConnection.this.currentState = newState;
            switch (newState) {
                case CONNECTED: {
                    logger.info(">>> Curator connected event: " + newState);
                    for (ZooKeeperConnectionListener listener : ZooKeeperConnection.this.listeners) {
                        listener.onConnect(client);
                    }
                    break;
                }
                case RECONNECTED: {
                    logger.info(">>> Curator reconnected event: " + newState);
                    for (ZooKeeperConnectionListener listener : ZooKeeperConnection.this.listeners) {
                        listener.onResume(client);
                    }
                    break;
                }
                case LOST: {
                    logger.info(">>> Curator disconnected event: " + newState);
                    for (ZooKeeperConnectionListener listener : ZooKeeperConnection.this.listeners) {
                        listener.onDisconnect(client);
                    }
                    break;
                }
                case SUSPENDED: {
                    logger.info(">>> Curator suspended event: " + newState);
                    for (ZooKeeperConnectionListener listener : ZooKeeperConnection.this.listeners) {
                        listener.onSuspend(client);
                    }
                    break;
                }
                case READ_ONLY: {
                    logger.info(">>> Curator read-only event: " + newState);
                }
            }
        }
    }
}

