/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.zookeeper;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.utils.EnsurePath;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class Paths {
    private static final ConcurrentMap<String, EnsurePath> ensurePaths = new ConcurrentHashMap<String, EnsurePath>();
    public static final String XD_NAMESPACE = "xd";
    public static final String ADMINELECTION = "adminelection";
    public static final String ADMINS = "admins";
    public static final String CONTAINERS = "containers";
    public static final String MODULES = "modules";
    public static final String STREAMS = "streams";
    public static final String JOBS = "jobs";
    public static final String TAPS = "taps";
    public static final String DEPLOYMENTS = "deployments";
    public static final String ALLOCATED = "allocated";
    public static final String METADATA = "metadata";
    public static final String REQUESTED = "requested";
    public static final String STATUS = "status";
    public static final String QUEUE = "queue";
    public static final String RESPONSES = "responses";
    public static final String MODULE_DEPLOYMENTS = "deployments/modules";
    public static final String STREAM_DEPLOYMENTS = "deployments/streams";
    public static final String JOB_DEPLOYMENTS = "deployments/jobs";
    public static final String DEPLOYMENT_QUEUE = "queue/deployments";

    public static String stripPath(String path) {
        int i = path.lastIndexOf(47);
        return i > -1 ? path.substring(i + 1) : path;
    }

    public static String build(String ... elements) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < elements.length; ++i) {
            if (i == 0 && elements[i].charAt(0) != '/') {
                builder.append('/');
            }
            builder.append(elements[i]);
            if (i + 1 >= elements.length) continue;
            builder.append('/');
        }
        return builder.toString();
    }

    public static void ensurePath(CuratorFramework client, String path) {
        EnsurePath ensurePath = (EnsurePath)ensurePaths.get(path);
        if (ensurePath == null) {
            ensurePaths.putIfAbsent(path, client.newNamespaceAwareEnsurePath(path));
            ensurePath = (EnsurePath)ensurePaths.get(path);
        }
        try {
            ensurePath.ensure(client.getZookeeperClient());
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }
}

