/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.zookeeper;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.UUID;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.ErrorHandler;
import org.springframework.util.SocketUtils;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class EmbeddedZooKeeper
implements SmartLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(EmbeddedZooKeeper.class);
    private final int clientPort;
    private boolean autoStartup = true;
    private int phase = 0;
    private volatile Thread zkServerThread;
    private volatile ZooKeeperServerMain zkServer;
    private ErrorHandler errorHandler;

    public EmbeddedZooKeeper() {
        this.clientPort = SocketUtils.findAvailableTcpPort();
    }

    public EmbeddedZooKeeper(int clientPort) {
        this.clientPort = clientPort;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isRunning() {
        return this.zkServerThread != null;
    }

    public synchronized void start() {
        if (this.zkServerThread == null) {
            this.zkServerThread = new Thread((Runnable)new ServerRunnable(), "ZooKeeper Server Starter");
            this.zkServerThread.setDaemon(true);
            this.zkServerThread.start();
        }
    }

    public synchronized void stop() {
        if (this.zkServerThread != null) {
            try {
                Method shutdown = ZooKeeperServerMain.class.getDeclaredMethod("shutdown", new Class[0]);
                shutdown.setAccessible(true);
                shutdown.invoke((Object)this.zkServer, new Object[0]);
            }
            catch (Exception e) {
                throw ZooKeeperUtils.wrapThrowable(e);
            }
            try {
                this.zkServerThread.join(5000L);
                this.zkServerThread = null;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Interrupted while waiting for embedded ZooKeeper to exit");
                this.zkServerThread = null;
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private class ServerRunnable
    implements Runnable {
        private ServerRunnable() {
        }

        @Override
        public void run() {
            try {
                Properties properties = new Properties();
                File file = new File(System.getProperty("java.io.tmpdir") + File.separator + UUID.randomUUID());
                file.deleteOnExit();
                properties.setProperty("dataDir", file.getAbsolutePath());
                properties.setProperty("clientPort", String.valueOf(EmbeddedZooKeeper.this.clientPort));
                QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
                quorumPeerConfig.parseProperties(properties);
                EmbeddedZooKeeper.this.zkServer = new ZooKeeperServerMain();
                ServerConfig configuration = new ServerConfig();
                configuration.readFrom(quorumPeerConfig);
                EmbeddedZooKeeper.this.zkServer.runFromConfig(configuration);
            }
            catch (Exception e) {
                if (EmbeddedZooKeeper.this.errorHandler != null) {
                    EmbeddedZooKeeper.this.errorHandler.handleError((Throwable)e);
                }
                logger.error("Exception running embedded ZooKeeper", (Throwable)e);
            }
        }
    }
}

