/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util.logging;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.springframework.util.StringUtils;

public class VersionPatternConverter
extends ClassicConverter {
    private final String version = this.loadVersion();

    public String convert(ILoggingEvent iLoggingEvent) {
        return this.version;
    }

    private String loadVersion() {
        String version = "unknown";
        try {
            String manifestPath;
            Manifest manifest;
            Attributes attributes;
            String value;
            Class<?> clz = ((Object)((Object)this)).getClass();
            String className = clz.getSimpleName() + ".class";
            String classPath = clz.getResource(className).toString();
            if (classPath.startsWith("jar") && StringUtils.hasText((String)(value = (attributes = (manifest = new Manifest(new URL(manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF").openStream())).getMainAttributes()).getValue("Implementation-Version")))) {
                version = value.replaceAll("BUILD-SNAPSHOT", "SNAP").replaceAll("-RELEASE", "");
            }
        }
        catch (Exception e) {
            System.out.println("Could not determine version of Spring XD via manifest");
            e.printStackTrace();
        }
        return version;
    }
}

