/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util.logging;

import ch.qos.logback.classic.pattern.Abbreviator;

public class LoggerAbbreviator
implements Abbreviator {
    private final int targetLength;

    LoggerAbbreviator(int targetLength) {
        this.targetLength = targetLength;
    }

    public String abbreviate(String fqClassName) {
        String[] toks = fqClassName.split("\\.");
        if (toks.length <= this.targetLength) {
            return fqClassName;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = toks.length - this.targetLength; i < toks.length; ++i) {
            sb.append(toks[i]);
            if (i >= toks.length - 1) continue;
            sb.append(".");
        }
        return sb.toString();
    }
}

