/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util.logging;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.springframework.xd.dirt.util.logging.LoggerAbbreviator;

public class CustomLoggerConverter
extends LoggerConverter {
    private Abbreviator abbreviator;

    public void start() {
        String optStr = this.getFirstOption();
        if (optStr != null) {
            try {
                int targetLen = Integer.parseInt(optStr);
                this.abbreviator = new LoggerAbbreviator(targetLen);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public String convert(ILoggingEvent event) {
        String fqn = this.getFullyQualifiedName(event);
        if (this.abbreviator == null) {
            return fqn;
        }
        return this.abbreviator.abbreviate(fqn);
    }
}

