/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util;

import java.util.Arrays;
import java.util.TreeSet;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.xd.dirt.cluster.ContainerAttributes;
import org.springframework.xd.dirt.util.RuntimeUtils;

public class XdConfigLoggingInitializer
implements ApplicationListener<ContextRefreshedEvent>,
EnvironmentAware {
    private static Logger logger = LoggerFactory.getLogger(XdConfigLoggingInitializer.class);
    protected ConfigurableEnvironment environment;
    private final boolean isContainer;
    private static final String HADOOP_DISTRO_OPTION = "${HADOOP_DISTRO}";
    private static final String ADMIN_PORT = "${server.port}";
    private static final String XD_CONFIG_LOCATION = "${xd.config.home}";
    private static final String XD_CONFIG_NAME = "${spring.config.name:servers}";
    private static final String XD_MODULE_CONFIG_LOCATION = "${xd.module.config.location:${xd.config.home}/modules/}";
    private static final String XD_MODULE_CONFIG_NAME = "${xd.module.config.name:modules}";
    private static final String XD_ZK_NAMESPACE = "${zk.namespace}";
    private ContainerAttributes containerAttributes;

    public XdConfigLoggingInitializer(boolean isContainer) {
        this.isContainer = isContainer;
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public void setContainerAttributes(ContainerAttributes containerAttributes) {
        Assert.notNull((Object)containerAttributes);
        this.containerAttributes = containerAttributes;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        logger.info("XD Home: " + this.environment.resolvePlaceholders("${XD_HOME}"));
        logger.info("Transport: " + this.environment.resolvePlaceholders("${XD_TRANSPORT}"));
        this.logHadoopDistro();
        this.logConfigLocations();
        if (this.isContainer) {
            this.logContainerInfo();
        } else {
            this.logAdminUI();
        }
        this.logZkConnectString();
        this.logZkNamespace();
        logger.info("Analytics: " + this.environment.resolvePlaceholders("${XD_ANALYTICS}"));
        if ("true".equals(this.environment.getProperty("verbose"))) {
            this.logAllProperties();
        }
    }

    private void logHadoopDistro() {
        if (ClassUtils.isPresent((String)"org.apache.hadoop.util.VersionInfo", (ClassLoader)this.getClass().getClassLoader())) {
            logger.info("Hadoop version detected from classpath " + VersionInfo.getVersion());
        } else {
            logger.info("Hadoop version not detected from classpath");
        }
    }

    private void logContainerInfo() {
        String containerHostname;
        String containerIp;
        if (this.containerAttributes != null) {
            containerIp = this.containerAttributes.getIp();
            containerHostname = this.containerAttributes.getHost();
        } else {
            containerIp = "N/A";
            containerHostname = "N/A";
        }
        logger.info("Container IP address: " + containerIp);
        logger.info("Container hostname:   " + containerHostname);
    }

    private void logConfigLocations() {
        logger.info("XD config location: " + this.environment.resolvePlaceholders(XD_CONFIG_LOCATION));
        logger.info("XD config names: " + this.environment.resolvePlaceholders(XD_CONFIG_NAME));
        logger.info("XD module config location: " + this.environment.resolvePlaceholders(XD_MODULE_CONFIG_LOCATION));
        logger.info("XD module config name: " + this.environment.resolvePlaceholders(XD_MODULE_CONFIG_NAME));
    }

    private void logAdminUI() {
        String httpPort = this.environment.resolvePlaceholders(ADMIN_PORT);
        Assert.notNull((Object)httpPort, (String)"Admin server port is not set.");
        logger.info("Admin web UI: " + String.format("http://%s:%s/%s", RuntimeUtils.getHost(), httpPort, "admin-ui"));
    }

    private void logZkConnectString() {
        PropertySource zkPropertySource = this.environment.getPropertySources().get("zk-properties");
        if (zkPropertySource != null) {
            String zkConnectString = (String)zkPropertySource.getProperty("zk.client.connect");
            String embeddedZkConnectString = (String)zkPropertySource.getProperty("zk.embedded.client.connect");
            String connectString = !StringUtils.hasText((String)zkConnectString) && StringUtils.hasText((String)embeddedZkConnectString) ? embeddedZkConnectString : zkConnectString;
            logger.info("Zookeeper at: " + connectString);
        }
    }

    private void logZkNamespace() {
        logger.info("Zookeeper namespace: " + this.environment.resolvePlaceholders(XD_ZK_NAMESPACE));
    }

    private void logAllProperties() {
        TreeSet<String> propertyNames = new TreeSet<String>();
        for (PropertySource ps : this.environment.getPropertySources()) {
            if (!(ps instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource eps = (EnumerablePropertySource)ps;
            propertyNames.addAll(Arrays.asList(eps.getPropertyNames()));
        }
        StringBuffer sb = new StringBuffer("\n");
        for (String key : propertyNames) {
            sb.append(String.format("\t%s=%s\n", key, this.environment.resolvePlaceholders(this.environment.getProperty(key).toString())));
        }
        logger.info(sb.toString());
    }
}

