/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public abstract class RuntimeUtils {
    public static String getHost() {
        String host;
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            host = "unknown";
        }
        return host;
    }

    public static String getIpAddress() {
        try {
            Enumeration<NetworkInterface> enumNic = NetworkInterface.getNetworkInterfaces();
            while (enumNic.hasMoreElements()) {
                NetworkInterface ifc = enumNic.nextElement();
                if (!ifc.isUp()) continue;
                Enumeration<InetAddress> enumAddr = ifc.getInetAddresses();
                while (enumAddr.hasMoreElements()) {
                    InetAddress address = enumAddr.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown";
    }

    public static int getPid() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        return jvmName.indexOf(64) != -1 ? Integer.parseInt(jvmName.split("@")[0]) : -1;
    }
}

