/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util;

import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.util.PageNotFoundException;

public class PagingUtility<T extends Comparable<? super T>> {
    public Page<T> getPagedData(Pageable pageable, List<T> list) throws PageNotFoundException {
        Assert.notNull((Object)pageable, (String)"Pagination info can't be null.");
        Assert.notNull(list, (String)"The provided list must not be null.");
        int offset = pageable.getOffset();
        int to = Math.min(list.size(), offset + pageable.getPageSize());
        if (offset > to) {
            throw new PageNotFoundException(String.format("Page %s does not exist.", pageable.getPageNumber()));
        }
        if (CollectionUtils.isEmpty(list)) {
            return new PageImpl(list);
        }
        Collections.sort(list);
        List<T> data = list.subList(offset, to);
        return new PageImpl(data, pageable, (long)list.size());
    }
}

