/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util;

import java.util.Map;
import org.springframework.xd.module.ModuleDeploymentProperties;
import org.springframework.xd.module.ModuleDescriptor;

public class DeploymentPropertiesUtility {
    public static ModuleDeploymentProperties createModuleDeploymentProperties(Map<String, String> deploymentProperties, ModuleDescriptor descriptor) {
        ModuleDeploymentProperties moduleDeploymentProperties = new ModuleDeploymentProperties();
        String wildcardPrefix = "module.*.";
        for (Map.Entry<String, String> prop : deploymentProperties.entrySet()) {
            String key = prop.getKey();
            if (!key.startsWith(wildcardPrefix)) continue;
            moduleDeploymentProperties.put(key.substring(wildcardPrefix.length()), prop.getValue());
        }
        String modulePrefix = String.format("module.%s.", descriptor.getModuleLabel());
        for (Map.Entry<String, String> prop : deploymentProperties.entrySet()) {
            String key = prop.getKey();
            if (!key.startsWith(modulePrefix)) continue;
            moduleDeploymentProperties.put(key.substring(modulePrefix.length()), prop.getValue());
        }
        return moduleDeploymentProperties;
    }
}

