/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.util;

import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.xd.dirt.util.XdUtils;

public final class BannerUtils {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private BannerUtils() {
        throw new AssertionError();
    }

    private static String getBanner() {
        String banner = BannerUtils.readBanner();
        String version = StringUtils.rightPad((String)BannerUtils.getVersion(), (int)33);
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(banner, version));
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    private static String readBanner() {
        try {
            return FileCopyUtils.copyToString((Reader)new InputStreamReader(BannerUtils.class.getResourceAsStream("banner.txt"))).replaceAll("(\\r|\\n)+", LINE_SEPARATOR);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not read banner.txt");
        }
    }

    public static String getVersion() {
        String version = XdUtils.getSpringXdVersion();
        return version != null ? version : "Unknown Version";
    }

    public static String displayBanner(String containerName, String additionalMessage) {
        StringBuffer sb = new StringBuffer(LINE_SEPARATOR);
        sb.append(BannerUtils.getBanner()).append(StringUtils.isEmpty((String)additionalMessage) ? "" : additionalMessage).append(LINE_SEPARATOR).append(StringUtils.isEmpty((String)containerName) ? "" : "Started : " + containerName).append(LINE_SEPARATOR).append("Documentation: http://docs.spring.io/spring-xd/docs/current/reference/html/").append(LINE_SEPARATOR);
        return sb.toString();
    }
}

