/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.test.process;

import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.MessageBus;
import org.springframework.xd.dirt.module.ResourceModuleRegistry;
import org.springframework.xd.dirt.server.singlenode.SingleNodeApplication;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.test.SingleNodeIntegrationTestSupport;
import org.springframework.xd.dirt.test.sink.NamedChannelSink;
import org.springframework.xd.dirt.test.sink.SingleNodeNamedQueueSink;
import org.springframework.xd.dirt.test.source.NamedChannelSource;
import org.springframework.xd.dirt.test.source.SingleNodeNamedQueueSource;

public abstract class AbstractSingleNodeProcessingChain {
    private static final String QUEUE_CONSUMER = "queue:consumer";
    private static final String QUEUE_PRODUCER = "queue:producer";
    private final StreamDefinition stream;
    private final MessageBus messageBus;
    protected final NamedChannelSource source;
    protected final NamedChannelSink sink;
    protected final SingleNodeIntegrationTestSupport integrationSupport;

    protected AbstractSingleNodeProcessingChain(SingleNodeApplication application, String streamName, String processingChain) {
        this(application, streamName, processingChain, "file:./config");
    }

    protected AbstractSingleNodeProcessingChain(SingleNodeApplication application, String streamName, String processingChain, String moduleResourceLocation) {
        Assert.notNull((Object)application, (String)"application cannot be null");
        Assert.hasText((String)processingChain, (String)"processingChain cannot be null or empty");
        Assert.hasText((String)streamName, (String)"streamName cannot be null or empty");
        Assert.hasText((String)moduleResourceLocation, (String)"moduleResourceLocation cannot be null or empty");
        this.integrationSupport = new SingleNodeIntegrationTestSupport(application);
        this.integrationSupport.addModuleRegistry(new ResourceModuleRegistry(moduleResourceLocation));
        String streamDefinition = this.buildStreamDefinition(processingChain);
        this.stream = new StreamDefinition(streamName, streamDefinition);
        this.integrationSupport.createAndDeployStream(this.stream);
        this.messageBus = this.integrationSupport.messageBus();
        this.sink = this.createSink() ? new SingleNodeNamedQueueSink(this.messageBus, QUEUE_CONSUMER) : null;
        this.source = this.createSource() ? new SingleNodeNamedQueueSource(this.messageBus, QUEUE_PRODUCER) : null;
    }

    private String buildStreamDefinition(String processingChain) {
        StringBuilder sb = new StringBuilder();
        if (this.createSource()) {
            sb.append(QUEUE_PRODUCER).append(">");
        }
        sb.append(processingChain);
        if (this.createSink()) {
            sb.append(">").append(QUEUE_CONSUMER);
        }
        return sb.toString();
    }

    public void unbind() {
        if (this.sink != null) {
            this.sink.unbind();
        }
        if (this.source != null) {
            this.source.unbind();
        }
    }

    public void destroy() {
        this.unbind();
        this.integrationSupport.undeployAndDestroyStream(this.stream);
    }

    protected abstract boolean createSink();

    protected abstract boolean createSource();
}

