/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.test;

import java.util.Collections;
import java.util.List;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.module.ModuleDefinition;
import org.springframework.xd.module.ModuleDefinitions;
import org.springframework.xd.module.ModuleType;

public class SingletonModuleRegistry
implements ModuleRegistry {
    private final String moduleName;
    private final ModuleType moduleType;
    private final String location;

    public SingletonModuleRegistry(ModuleType moduleType, String moduleName) {
        this(moduleType, moduleName, "classpath:");
    }

    public SingletonModuleRegistry(ModuleType moduleType, String moduleName, String location) {
        this.moduleName = moduleName;
        this.moduleType = moduleType;
        this.location = location;
    }

    @Override
    public ModuleDefinition findDefinition(String name, ModuleType moduleType) {
        if (this.moduleName.equals(name) && this.moduleType == moduleType) {
            return ModuleDefinitions.simple((String)this.moduleName, (ModuleType)moduleType, (String)this.location);
        }
        return null;
    }

    @Override
    public List<ModuleDefinition> findDefinitions(String name) {
        if (this.moduleName.equals(name)) {
            return Collections.singletonList(ModuleDefinitions.simple((String)this.moduleName, (ModuleType)this.moduleType, (String)this.location));
        }
        return Collections.emptyList();
    }

    @Override
    public List<ModuleDefinition> findDefinitions(ModuleType type) {
        if (type == this.moduleType) {
            return Collections.singletonList(ModuleDefinitions.simple((String)this.moduleName, (ModuleType)this.moduleType, (String)this.location));
        }
        return Collections.emptyList();
    }

    @Override
    public List<ModuleDefinition> findDefinitions() {
        return Collections.singletonList(ModuleDefinitions.simple((String)this.moduleName, (ModuleType)this.moduleType, (String)this.location));
    }
}

