/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.springframework.util.Assert;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.integration.bus.MessageBusSupport;
import org.springframework.xd.dirt.module.DelegatingModuleRegistry;
import org.springframework.xd.dirt.module.ModuleDeployer;
import org.springframework.xd.dirt.module.ModuleRegistry;
import org.springframework.xd.dirt.server.singlenode.SingleNodeApplication;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xd.dirt.stream.JobRepository;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.stream.StreamDefinitionRepository;
import org.springframework.xd.dirt.stream.StreamDeployer;
import org.springframework.xd.dirt.stream.StreamRepository;
import org.springframework.xd.dirt.test.ResourceStateVerifier;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.core.Module;

public class SingleNodeIntegrationTestSupport {
    private static final Map<String, String> EMPTY_PROPERTIES = Collections.emptyMap();
    private final JobDefinitionRepository jobDefinitionRepository;
    private final StreamDefinitionRepository streamDefinitionRepository;
    private final StreamRepository streamRepository;
    private final JobRepository jobRepository;
    private final StreamDeployer streamDeployer;
    private final MessageBusSupport messageBus;
    private final ModuleDeployer moduleDeployer;
    private final ZooKeeperConnection zooKeeperConnection;
    private final ResourceStateVerifier streamResourceStateVerifier;
    private final ResourceStateVerifier jobResourceStateVerifier;
    private final SingleNodeApplication application;
    private final Map<String, PathChildrenCache> mapChildren = new HashMap<String, PathChildrenCache>();

    public SingleNodeIntegrationTestSupport(SingleNodeApplication application) {
        Assert.notNull((Object)application, (String)"SingleNodeApplication must not be null");
        this.application = application;
        this.streamDefinitionRepository = (StreamDefinitionRepository)application.pluginContext().getBean(StreamDefinitionRepository.class);
        this.jobDefinitionRepository = (JobDefinitionRepository)application.pluginContext().getBean(JobDefinitionRepository.class);
        this.streamRepository = (StreamRepository)application.pluginContext().getBean(StreamRepository.class);
        this.jobRepository = (JobRepository)application.pluginContext().getBean(JobRepository.class);
        this.streamResourceStateVerifier = new ResourceStateVerifier(this.streamRepository, this.streamDefinitionRepository);
        this.jobResourceStateVerifier = new ResourceStateVerifier(this.jobRepository, this.jobDefinitionRepository);
        this.streamDeployer = (StreamDeployer)application.adminContext().getBean(StreamDeployer.class);
        this.messageBus = (MessageBusSupport)application.pluginContext().getBean(MessageBusSupport.class);
        this.zooKeeperConnection = (ZooKeeperConnection)application.adminContext().getBean(ZooKeeperConnection.class);
        this.moduleDeployer = (ModuleDeployer)application.containerContext().getBean(ModuleDeployer.class);
    }

    public final void addModuleRegistry(ModuleRegistry moduleRegistry) {
        DelegatingModuleRegistry cmr1 = (DelegatingModuleRegistry)this.application.pluginContext().getBean(DelegatingModuleRegistry.class);
        cmr1.addDelegate(moduleRegistry);
        DelegatingModuleRegistry cmr2 = (DelegatingModuleRegistry)this.application.adminContext().getBean(DelegatingModuleRegistry.class);
        if (cmr1 != cmr2) {
            cmr2.addDelegate(moduleRegistry);
        }
    }

    public final Map<String, Map<Integer, Module>> getDeployedModules() {
        Assert.notNull((Object)this.moduleDeployer, (String)"ModuleDeployer is required to get deployed modules.");
        return this.moduleDeployer.getDeployedModules();
    }

    public final StreamDeployer streamDeployer() {
        return this.streamDeployer;
    }

    public final StreamRepository streamRepository() {
        return this.streamRepository;
    }

    public final ResourceStateVerifier streamStateVerifier() {
        return this.streamResourceStateVerifier;
    }

    public final ResourceStateVerifier jobStateVerifier() {
        return this.jobResourceStateVerifier;
    }

    public final JobRepository jobRepository() {
        return this.jobRepository;
    }

    public final JobDefinitionRepository jobDefinitionRepository() {
        return this.jobDefinitionRepository;
    }

    public final StreamDefinitionRepository streamDefinitionRepository() {
        return this.streamDefinitionRepository;
    }

    public final MessageBusSupport messageBus() {
        return this.messageBus;
    }

    public final boolean deployStream(StreamDefinition definition) {
        return this.waitForDeploy(definition);
    }

    public final boolean deployStream(StreamDefinition definition, Map<String, String> properties) {
        return this.waitForDeploy(definition, properties);
    }

    public final boolean deployStream(StreamDefinition definition, Map<String, String> properties, boolean allowIncomplete) {
        return this.waitForDeploy(definition, properties, allowIncomplete);
    }

    public final boolean createAndDeployStream(StreamDefinition definition) {
        this.streamDeployer.save(definition);
        return this.waitForDeploy(definition);
    }

    public final boolean undeployStream(StreamDefinition definition) {
        return this.waitForUndeploy(definition);
    }

    public final boolean undeployAndDestroyStream(StreamDefinition definition) {
        boolean result = this.waitForUndeploy(definition);
        this.streamDeployer.delete(definition.getName());
        return result;
    }

    public final void deleteStream(String name) {
        this.streamDeployer.delete(name);
    }

    public final Module getModule(String streamName, String moduleName, int index) {
        Map<Integer, Module> modules = this.getDeployedModules().get(streamName);
        return modules != null ? modules.get(index) : null;
    }

    public ZooKeeperConnection zooKeeperConnection() {
        return this.zooKeeperConnection;
    }

    public void addPathListener(String path, PathChildrenCacheListener listener) {
        PathChildrenCache cache = this.mapChildren.get(path);
        if (cache == null) {
            cache = new PathChildrenCache(this.zooKeeperConnection.getClient(), path, true);
            this.mapChildren.put(path, cache);
            try {
                cache.getListenable().addListener((Object)listener);
                cache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
            }
            catch (Exception e) {
                throw ZooKeeperUtils.wrapThrowable(e);
            }
        } else {
            cache.getListenable().addListener((Object)listener);
        }
    }

    public void removePathListener(String path, PathChildrenCacheListener listener) {
        PathChildrenCache cache = this.mapChildren.get(path);
        if (cache != null) {
            cache.getListenable().removeListener((Object)listener);
            if (cache.getListenable().size() == 0) {
                try {
                    cache.close();
                    this.mapChildren.remove(path);
                }
                catch (Exception e) {
                    throw ZooKeeperUtils.wrapThrowable(e);
                }
            }
        }
    }

    private boolean waitForUndeploy(StreamDefinition definition) {
        this.streamDeployer.undeploy(definition.getName());
        DeploymentUnitStatus.State state = this.streamResourceStateVerifier.waitForUndeploy(definition.getName());
        return state.equals((Object)DeploymentUnitStatus.State.undeployed);
    }

    private boolean waitForDeploy(StreamDefinition definition) {
        return this.waitForDeploy(definition, EMPTY_PROPERTIES);
    }

    private boolean waitForDeploy(StreamDefinition definition, Map<String, String> properties) {
        this.streamDeployer.deploy(definition.getName(), properties);
        DeploymentUnitStatus.State state = this.streamStateVerifier().waitForDeploy(definition.getName());
        return state.equals((Object)DeploymentUnitStatus.State.deployed);
    }

    private boolean waitForDeploy(StreamDefinition definition, Map<String, String> properties, boolean allowIncomplete) {
        this.streamDeployer.deploy(definition.getName(), properties);
        DeploymentUnitStatus.State state = this.streamResourceStateVerifier.waitForDeploy(definition.getName(), allowIncomplete);
        if (allowIncomplete) {
            return state.equals((Object)DeploymentUnitStatus.State.deployed) || state.equals((Object)DeploymentUnitStatus.State.incomplete);
        }
        return state.equals((Object)DeploymentUnitStatus.State.deployed);
    }
}

