/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.test;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.xd.dirt.core.BaseDefinition;
import org.springframework.xd.dirt.core.DeploymentStatusRepository;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.store.DomainRepository;

public class ResourceStateVerifier {
    private static final long STATE_CHANGE_WAIT_TIME = 50L;
    private static final long STATE_CHANGE_TIMEOUT = 35000L;
    private final DeploymentStatusRepository<?, String> deploymentStatusRepository;
    private final DomainRepository<? extends BaseDefinition, String> domainRepository;

    public ResourceStateVerifier(DeploymentStatusRepository<?, String> deploymentStatusRepository, DomainRepository<? extends BaseDefinition, String> domainRepository) {
        this.deploymentStatusRepository = deploymentStatusRepository;
        this.domainRepository = domainRepository;
    }

    public DeploymentUnitStatus.State waitForDeploy(String resourceName) {
        return this.waitForDeploy(resourceName, false);
    }

    public DeploymentUnitStatus.State waitForDeploy(String resourceName, boolean allowIncomplete) {
        if (allowIncomplete) {
            return this.waitForDeployState(resourceName, DeploymentUnitStatus.State.deployed, DeploymentUnitStatus.State.incomplete);
        }
        return this.waitForDeployState(resourceName, DeploymentUnitStatus.State.deployed);
    }

    public DeploymentUnitStatus.State waitForUndeploy(String resourceName) {
        return this.waitForDeployState(resourceName, DeploymentUnitStatus.State.undeployed);
    }

    public boolean waitForCreate(String resourceName) {
        boolean exists;
        long waitTime = 0L;
        while (!(exists = this.domainRepository.exists((Serializable)((Object)resourceName))) && waitTime < 35000L) {
            try {
                Thread.sleep(50L);
                waitTime += 50L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return exists;
    }

    public boolean waitForDestroy(String resourceName) {
        boolean exists;
        long waitTime = 0L;
        while ((exists = this.domainRepository.exists((Serializable)((Object)resourceName))) && waitTime < 35000L) {
            try {
                Thread.sleep(50L);
                waitTime += 50L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return exists;
    }

    DeploymentUnitStatus.State waitForDeployState(String resourceName, DeploymentUnitStatus.State ... targetStates) {
        DeploymentUnitStatus.State currentState = this.deploymentStatusRepository.getDeploymentStatus(resourceName).getState();
        long waitTime = 0L;
        List<DeploymentUnitStatus.State> targetStateList = Arrays.asList(targetStates);
        while (!targetStateList.contains((Object)currentState) && waitTime < 35000L) {
            try {
                Thread.sleep(50L);
                currentState = this.deploymentStatusRepository.getDeploymentStatus(resourceName).getState();
                waitTime += 50L;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return currentState;
    }
}

