/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.test;

import org.springframework.util.Assert;
import org.springframework.xd.dirt.integration.bus.MessageBus;

public abstract class AbstractSingleNodeNamedChannelModuleFactory {
    protected static final String QUEUE_PREFIX = "queue:";
    protected static final String TOPIC_PREFIX = "topic:";
    protected final MessageBus messageBus;

    protected AbstractSingleNodeNamedChannelModuleFactory(MessageBus messageBus) {
        Assert.notNull((Object)messageBus, (String)"messageBus cannot be null");
        this.messageBus = messageBus;
    }

    protected void validateChannelName(String channelName) {
        Assert.notNull((Object)channelName, (String)"channelName cannot be null");
        Assert.isTrue((channelName.startsWith(QUEUE_PREFIX) || channelName.startsWith(TOPIC_PREFIX) ? 1 : 0) != 0, (String)String.format("channel name %s is not well formed. It must start with %s or %s", channelName, QUEUE_PREFIX, TOPIC_PREFIX));
    }
}

