/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.zookeeper;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.xd.dirt.module.ModuleDependencyRepository;
import org.springframework.xd.dirt.stream.StreamDefinition;
import org.springframework.xd.dirt.stream.StreamDefinitionRepository;
import org.springframework.xd.dirt.stream.StreamDefinitionRepositoryUtils;
import org.springframework.xd.dirt.stream.zookeeper.RepositoryConnectionListener;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;
import org.springframework.xd.module.ModuleDefinition;

public class ZooKeeperStreamDefinitionRepository
implements StreamDefinitionRepository,
InitializingBean {
    private static final String DEFINITION_KEY = "definition";
    private static final String MODULE_DEFINITIONS_KEY = "moduleDefinitions";
    private static final TypeReference<List<ModuleDefinition>> MODULE_DEFINITIONS_LIST = new TypeReference<List<ModuleDefinition>>(){};
    private final Logger logger = LoggerFactory.getLogger(ZooKeeperStreamDefinitionRepository.class);
    private final ZooKeeperConnection zkConnection;
    private final ModuleDependencyRepository moduleDependencyRepository;
    private final PagingUtility<StreamDefinition> pagingUtility = new PagingUtility();
    private final RepositoryConnectionListener connectionListener = new RepositoryConnectionListener();
    private final ObjectWriter objectWriter = new ObjectMapper().writerWithType(MODULE_DEFINITIONS_LIST);
    private final ObjectReader objectReader = new ObjectMapper().reader(MODULE_DEFINITIONS_LIST);

    @Autowired
    public ZooKeeperStreamDefinitionRepository(ZooKeeperConnection zkConnection, ModuleDependencyRepository moduleDependencyRepository) {
        this.zkConnection = zkConnection;
        this.moduleDependencyRepository = moduleDependencyRepository;
    }

    public void afterPropertiesSet() throws Exception {
        this.zkConnection.addListener(this.connectionListener);
        if (this.zkConnection.isConnected()) {
            this.connectionListener.onConnect(this.zkConnection.getClient());
        }
    }

    public Iterable<StreamDefinition> findAll(Sort sort) {
        throw new UnsupportedOperationException("Auto-generated method stub");
    }

    public Page<StreamDefinition> findAll(Pageable pageable) {
        return this.pagingUtility.getPagedData(pageable, (List<StreamDefinition>)this.findAll());
    }

    public <S extends StreamDefinition> Iterable<S> save(Iterable<S> entities) {
        ArrayList<StreamDefinition> results = new ArrayList<StreamDefinition>();
        for (StreamDefinition entity : entities) {
            results.add(this.save(entity));
        }
        return results;
    }

    public <S extends StreamDefinition> S save(S entity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(DEFINITION_KEY, entity.getDefinition());
            map.put(MODULE_DEFINITIONS_KEY, this.objectWriter.writeValueAsString(entity.getModuleDefinitions()));
            CuratorFramework client = this.zkConnection.getClient();
            String path = Paths.build("streams", entity.getName());
            byte[] binary = ZooKeeperUtils.mapToBytes(map);
            CreateBuilder op = client.checkExists().forPath(path) == null ? client.create() : client.setData();
            op.forPath(path, binary);
            this.logger.trace("Saved stream {} with properties {}", (Object)path, map);
            StreamDefinitionRepositoryUtils.saveDependencies(this.moduleDependencyRepository, entity);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
        }
        return entity;
    }

    public StreamDefinition findOne(String id) {
        try {
            byte[] bytes = (byte[])this.zkConnection.getClient().getData().forPath(Paths.build("streams", id));
            if (bytes == null) {
                return null;
            }
            Map<String, String> map = ZooKeeperUtils.bytesToMap(bytes);
            StreamDefinition streamDefinition = new StreamDefinition(id, map.get(DEFINITION_KEY));
            if (map.get(MODULE_DEFINITIONS_KEY) != null) {
                List moduleDefinitions = (List)this.objectReader.readValue(map.get(MODULE_DEFINITIONS_KEY));
                streamDefinition.setModuleDefinitions(moduleDefinitions);
            }
            return streamDefinition;
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
            return null;
        }
    }

    public boolean exists(String id) {
        try {
            return null != this.zkConnection.getClient().checkExists().forPath(Paths.build("streams", id));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<StreamDefinition> findAll() {
        try {
            return this.findAll((Iterable)this.zkConnection.getClient().getChildren().forPath("streams"));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<StreamDefinition> findAll(Iterable<String> ids) {
        ArrayList<StreamDefinition> results = new ArrayList<StreamDefinition>();
        for (String id : ids) {
            StreamDefinition sd = this.findOne(id);
            if (sd == null) continue;
            results.add(sd);
        }
        return results;
    }

    public long count() {
        try {
            Stat stat = (Stat)this.zkConnection.getClient().checkExists().forPath("streams");
            return stat == null ? 0L : (long)stat.getNumChildren();
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public void delete(String id) {
        this.logger.trace("Deleting stream {}", (Object)id);
        String path = Paths.build("streams", id);
        try {
            this.zkConnection.getClient().delete().deletingChildrenIfNeeded().forPath(path);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public void delete(StreamDefinition entity) {
        StreamDefinitionRepositoryUtils.deleteDependencies(this.moduleDependencyRepository, entity);
        this.delete(entity.getName());
    }

    public void delete(Iterable<? extends StreamDefinition> entities) {
        for (StreamDefinition streamDefinition : entities) {
            this.delete(streamDefinition);
        }
    }

    public void deleteAll() {
        try {
            this.delete(this.findAll());
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public Iterable<StreamDefinition> findAllInRange(String from, boolean fromInclusive, String to, boolean toInclusive) {
        throw new UnsupportedOperationException("Auto-generated method stub");
    }
}

