/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.zookeeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.xd.dirt.core.DeploymentUnitStatus;
import org.springframework.xd.dirt.stream.Job;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.dirt.stream.JobRepository;
import org.springframework.xd.dirt.stream.zookeeper.RepositoryConnectionListener;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ZooKeeperJobRepository
implements JobRepository,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperJobRepository.class);
    private final ZooKeeperConnection zkConnection;
    private final PagingUtility<Job> pagingUtility = new PagingUtility();
    private final RepositoryConnectionListener connectionListener = new RepositoryConnectionListener();

    @Autowired
    public ZooKeeperJobRepository(ZooKeeperConnection zkConnection) {
        this.zkConnection = zkConnection;
    }

    public void afterPropertiesSet() throws Exception {
        this.zkConnection.addListener(this.connectionListener);
        if (this.zkConnection.isConnected()) {
            this.connectionListener.onConnect(this.zkConnection.getClient());
        }
    }

    public Iterable<Job> findAll(Sort sort) {
        return this.findAll();
    }

    public Page<Job> findAll(Pageable pageable) {
        return this.pagingUtility.getPagedData(pageable, (List<Job>)this.findAll());
    }

    public <S extends Job> S save(S entity) {
        return entity;
    }

    public <S extends Job> Iterable<S> save(Iterable<S> entities) {
        return entities;
    }

    public Job findOne(String id) {
        CuratorFramework client = this.zkConnection.getClient();
        String path = Paths.build("jobs", id);
        try {
            Stat definitionStat = (Stat)client.checkExists().forPath(path);
            if (definitionStat != null) {
                byte[] data = (byte[])this.zkConnection.getClient().getData().forPath(path);
                Map<String, String> map = ZooKeeperUtils.bytesToMap(data);
                Job job = new Job(new JobDefinition(id, map.get("definition")));
                Stat deployStat = (Stat)client.checkExists().forPath(Paths.build("deployments/jobs", id));
                if (deployStat != null) {
                    job.setStartedAt(new Date(deployStat.getCtime()));
                    job.setStatus(this.getDeploymentStatus(id));
                    return job;
                }
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return null;
    }

    public boolean exists(String id) {
        return null != this.findOne(id);
    }

    public List<Job> findAll() {
        try {
            return this.findAll((Iterable)this.zkConnection.getClient().getChildren().forPath("jobs"));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<Job> findAll(Iterable<String> ids) {
        ArrayList<Job> results = new ArrayList<Job>();
        try {
            for (String jobName : ids) {
                Job job = this.findOne(jobName);
                if (job == null) continue;
                results.add(job);
            }
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
        return results;
    }

    public long count() {
        try {
            Stat stat = (Stat)this.zkConnection.getClient().checkExists().forPath("deployments/jobs");
            return stat != null ? (long)stat.getNumChildren() : 0L;
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public void delete(String id) {
        CuratorFramework client = this.zkConnection.getClient();
        try {
            client.setData().forPath(Paths.build("deployments/jobs", id, "status"), ZooKeeperUtils.mapToBytes(new DeploymentUnitStatus(DeploymentUnitStatus.State.undeploying).toMap()));
        }
        catch (Exception e) {
            logger.warn("Exception while transitioning job '{}' state to {}", new Object[]{id, DeploymentUnitStatus.State.undeploying, e});
        }
        try {
            client.delete().deletingChildrenIfNeeded().forPath(Paths.build("deployments/jobs", id));
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public void delete(Job entity) {
        this.delete(((JobDefinition)entity.getDefinition()).getName());
    }

    public void delete(Iterable<? extends Job> entities) {
        for (Job job : entities) {
            this.delete(job);
        }
    }

    public void deleteAll() {
        try {
            List children = (List)this.zkConnection.getClient().getChildren().forPath("deployments/jobs");
            for (String child : children) {
                this.delete(child);
            }
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public Iterable<Job> findAllInRange(String from, boolean fromInclusive, String to, boolean toInclusive) {
        Job job;
        Iterable all = this.findAll();
        if (CollectionUtils.isEmpty((Collection)all)) {
            return Collections.emptyList();
        }
        Collections.sort(all);
        ArrayList<Job> results = new ArrayList<Job>();
        Iterator i$ = all.iterator();
        while (i$.hasNext() && ((JobDefinition)(job = (Job)i$.next()).getDefinition()).getName().compareTo(to) <= 0) {
            if (((JobDefinition)job.getDefinition()).getName().compareTo(from) < 0) continue;
            results.add(job);
        }
        return results;
    }

    @Override
    public DeploymentUnitStatus getDeploymentStatus(String s) {
        String path = Paths.build("deployments/jobs", s, "status");
        byte[] statusBytes = null;
        try {
            statusBytes = (byte[])this.zkConnection.getClient().getData().forPath(path);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
        return statusBytes == null ? new DeploymentUnitStatus(DeploymentUnitStatus.State.undeployed) : new DeploymentUnitStatus(ZooKeeperUtils.bytesToMap(statusBytes));
    }
}

