/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.zookeeper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.CreateBuilder;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.xd.dirt.stream.JobDefinition;
import org.springframework.xd.dirt.stream.JobDefinitionRepository;
import org.springframework.xd.dirt.stream.zookeeper.RepositoryConnectionListener;
import org.springframework.xd.dirt.util.PagingUtility;
import org.springframework.xd.dirt.zookeeper.Paths;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnection;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class ZooKeeperJobDefinitionRepository
implements JobDefinitionRepository,
InitializingBean {
    private final Logger logger = LoggerFactory.getLogger(ZooKeeperJobDefinitionRepository.class);
    private final ZooKeeperConnection zkConnection;
    private final PagingUtility<JobDefinition> pagingUtility = new PagingUtility();
    private final RepositoryConnectionListener connectionListener = new RepositoryConnectionListener();

    @Autowired
    public ZooKeeperJobDefinitionRepository(ZooKeeperConnection zkConnection) {
        this.zkConnection = zkConnection;
    }

    public void afterPropertiesSet() throws Exception {
        this.zkConnection.addListener(this.connectionListener);
        if (this.zkConnection.isConnected()) {
            this.connectionListener.onConnect(this.zkConnection.getClient());
        }
    }

    public Iterable<JobDefinition> findAll(Sort sort) {
        Iterable all = this.findAll();
        Collections.sort(all);
        return all;
    }

    public Page<JobDefinition> findAll(Pageable pageable) {
        return this.pagingUtility.getPagedData(pageable, (List<JobDefinition>)this.findAll());
    }

    public <S extends JobDefinition> Iterable<S> save(Iterable<S> entities) {
        ArrayList<JobDefinition> results = new ArrayList<JobDefinition>();
        for (JobDefinition entity : entities) {
            results.add(this.save(entity));
        }
        return results;
    }

    public <S extends JobDefinition> S save(S entity) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("definition", entity.getDefinition());
            CuratorFramework client = this.zkConnection.getClient();
            String path = Paths.build("jobs", entity.getName());
            byte[] binary = ZooKeeperUtils.mapToBytes(map);
            CreateBuilder op = client.checkExists().forPath(path) == null ? client.create() : client.setData();
            op.forPath(path, binary);
            this.logger.info("Saved job {} with properties {}", (Object)path, map);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
        }
        return entity;
    }

    public JobDefinition findOne(String id) {
        try {
            byte[] bytes = (byte[])this.zkConnection.getClient().getData().forPath(Paths.build("jobs", id));
            if (bytes == null) {
                return null;
            }
            Map<String, String> map = ZooKeeperUtils.bytesToMap(bytes);
            return new JobDefinition(id, map.get("definition"));
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
            return null;
        }
    }

    public boolean exists(String id) {
        try {
            return null != this.zkConnection.getClient().checkExists().forPath(Paths.build("jobs", id));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<JobDefinition> findAll() {
        try {
            return this.findAll((Iterable)this.zkConnection.getClient().getChildren().forPath("jobs"));
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public List<JobDefinition> findAll(Iterable<String> ids) {
        ArrayList<JobDefinition> results = new ArrayList<JobDefinition>();
        for (String id : ids) {
            results.add(this.findOne(id));
        }
        return results;
    }

    public long count() {
        try {
            Stat stat = (Stat)this.zkConnection.getClient().checkExists().forPath("jobs");
            return stat == null ? 0L : (long)stat.getNumChildren();
        }
        catch (Exception e) {
            throw ZooKeeperUtils.wrapThrowable(e);
        }
    }

    public void delete(String id) {
        try {
            this.zkConnection.getClient().delete().deletingChildrenIfNeeded().forPath(Paths.build("jobs", id));
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public void delete(JobDefinition entity) {
        this.delete(entity.getName());
    }

    public void delete(Iterable<? extends JobDefinition> entities) {
        for (JobDefinition jobDefinition : entities) {
            this.delete(jobDefinition);
        }
    }

    public void deleteAll() {
        try {
            this.delete(this.findAll());
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NoNodeException.class);
        }
    }

    public Iterable<JobDefinition> findAllInRange(String from, boolean fromInclusive, String to, boolean toInclusive) {
        JobDefinition definition;
        Iterable all = this.findAll();
        if (CollectionUtils.isEmpty((Collection)all)) {
            return Collections.emptyList();
        }
        Collections.sort(all);
        ArrayList<JobDefinition> results = new ArrayList<JobDefinition>();
        Iterator i$ = all.iterator();
        while (i$.hasNext() && (definition = (JobDefinition)i$.next()).getName().compareTo(to) <= 1) {
            if (definition.getName().compareTo(from) < 0) continue;
            results.add(definition);
        }
        return results;
    }
}

