/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.apache.zookeeper.KeeperException;
import org.springframework.xd.dirt.zookeeper.ZooKeeperConnectionListener;
import org.springframework.xd.dirt.zookeeper.ZooKeeperUtils;

public class RepositoryConnectionListener
implements ZooKeeperConnectionListener {
    @Override
    public void onConnect(CuratorFramework client) {
        this.ensurePath(client, "streams");
        this.ensurePath(client, "jobs");
        this.ensurePath(client, "deployments/streams");
        this.ensurePath(client, "deployments/jobs");
    }

    @Override
    public void onResume(CuratorFramework client) {
    }

    @Override
    public void onDisconnect(CuratorFramework client) {
    }

    @Override
    public void onSuspend(CuratorFramework client) {
    }

    private void ensurePath(CuratorFramework client, String path) {
        try {
            client.create().creatingParentsIfNeeded().forPath(path);
        }
        catch (Exception e) {
            ZooKeeperUtils.wrapAndThrowIgnoring(e, KeeperException.NodeExistsException.class);
        }
    }
}

