/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.xd.dirt.stream.dsl;

import java.text.MessageFormat;

public enum XDDSLMessages {
    UNEXPECTED_DATA_AFTER_STREAMDEF(Kind.ERROR, 100, "Found unexpected data after stream definition: ''{0}''"),
    NO_WHITESPACE_BEFORE_ARG_NAME(Kind.ERROR, 101, "No whitespace allowed between '--' and option name"),
    NO_WHITESPACE_BEFORE_ARG_EQUALS(Kind.ERROR, 102, "No whitespace allowed after argument name and before '='"),
    NO_WHITESPACE_BEFORE_ARG_VALUE(Kind.ERROR, 103, "No whitespace allowed after '=' and before option value"),
    MORE_INPUT(Kind.ERROR, 104, "After parsing a valid stream, there is still more data: ''{0}''"),
    EXPECTED_ARGUMENT_VALUE(Kind.ERROR, 105, "Expected an argument value but was ''{0}''"),
    NON_TERMINATING_DOUBLE_QUOTED_STRING(Kind.ERROR, 106, "Cannot find terminating \" for string"),
    NON_TERMINATING_QUOTED_STRING(Kind.ERROR, 107, "Cannot find terminating '' for string"),
    MISSING_CHARACTER(Kind.ERROR, 108, "missing expected character ''{0}''"),
    NOT_EXPECTED_TOKEN(Kind.ERROR, 111, "Unexpected token.  Expected ''{0}'' but was ''{1}''"),
    OOD(Kind.ERROR, 112, "Unexpectedly ran out of input"),
    UNEXPECTED_ESCAPE_CHAR(Kind.ERROR, 114, "unexpected escape character."),
    UNEXPECTED_DATA(Kind.ERROR, 115, "unexpected data in stream definition ''{0}''"),
    UNRECOGNIZED_STREAM_REFERENCE(Kind.ERROR, 116, "unrecognized stream reference ''{0}''"),
    UNRECOGNIZED_MODULE_REFERENCE(Kind.ERROR, 117, "unrecognized module reference ''{0}''"),
    EXPECTED_MODULENAME(Kind.ERROR, 118, "expected module name but found ''{0}''"),
    EXPECTED_WHITESPACE_AFTER_MODULE_BEFORE_ARGUMENT(Kind.ERROR, 119, "expected whitespace after module name and before argument"),
    EXPECTED_CHANNEL_QUALIFIER(Kind.ERROR, 120, "expected channel reference '':<channel>'' but found ''{0}''"),
    EXPECTED_CHANNEL_NAME(Kind.ERROR, 121, "expected channel name but found ''{0}''"),
    ILLEGAL_STREAM_NAME(Kind.ERROR, 122, "illegal name for a stream ''{0}''"),
    MISSING_VALUE_FOR_VARIABLE(Kind.ERROR, 125, "no value specified for variable ''{0}'' when using substream"),
    VARIABLE_NOT_TERMINATED(Kind.ERROR, 126, "unable to find variable terminator ''}'' in argument ''{0}''"),
    AMBIGUOUS_MODULE_NAME(Kind.ERROR, 129, "ambiguous module name ''{0}'' in stream named ''{1}'', appears at both position {2} and {3}"),
    STREAM_NAME_MATCHING_MODULE_NAME(Kind.ERROR, 130, "Stream name ''{0}'' same as that of its modules' names is not allowed."),
    CHANNEL_INDEXING_NOT_ALLOWED(Kind.ERROR, 131, "Channel does not support indexing"),
    ONLY_A_TAP_ON_A_STREAM_OR_JOB_CAN_BE_INDEXED(Kind.ERROR, 132, "Only a tap on a stream or job can be indexed"),
    EXPECTED_CHANNEL_PREFIX_QUEUE_TOPIC(Kind.ERROR, 133, "Expected channel prefix of ''queue'' or ''topic'' but found ''{0}''"),
    EXPECTED_CHANNEL_PREFIX_QUEUE_TOPIC_TAP(Kind.ERROR, 134, "Expected channel prefix of ''queue'', ''topic'' or ''tap'' but found ''{0}''"),
    CANNOT_USE_COMPOSEDMODULE_HERE_AS_IT_DEFINES_SOURCE_CHANNEL(Kind.ERROR, 135, "cannot use composed module ''{0}'' here because it defines a source channel"),
    CANNOT_USE_COMPOSEDMODULE_HERE_AS_IT_DEFINES_SINK_CHANNEL(Kind.ERROR, 136, "cannot use composed module ''{0}'' here because it defines a sink channel"),
    CANNOT_USE_COMPOSEDMODULE_HERE_ALREADY_HAS_SOURCE_CHANNEL(Kind.ERROR, 137, "cannot use composed module ''{0}'' here, both that composed module and this stream define a source channel"),
    CANNOT_USE_COMPOSEDMODULE_HERE_ALREADY_HAS_SINK_CHANNEL(Kind.ERROR, 138, "cannot use composed module ''{0}'' here, both that composed module and this stream define a sink channel"),
    NO_WHITESPACE_IN_CHANNEL_DEFINITION(Kind.ERROR, 139, "no whitespace allowed between components in a channel name"),
    NO_WHITESPACE_BETWEEN_LABEL_NAME_AND_COLON(Kind.ERROR, 140, "no whitespace allowed between label name and colon"),
    TAP_NEEDS_THREE_COMPONENTS(Kind.ERROR, 141, "a tap needs at least three components (tap:queue:[name], tap:topic:[name], tap:stream:[streamname] or tap:job:[jobname])"),
    NOT_ALLOWED_TO_TAP_THAT(Kind.ERROR, 142, "tapping only allowed on 'stream', 'topic', 'job' or 'queue'. Not allowed on ''{0}''"),
    DUPLICATE_LABEL(Kind.ERROR, 143, "Label ''{0}'' should be unique but module ''{1}'' (at position {2}) and module ''{3}'' (at position {4}) both use it"),
    MODULE_REFERENCE_NOT_UNIQUE(Kind.ERROR, 144, "Reference to ''{0}'' is not unique in the target stream ''{1}'', please label the relevant module and use the label, or use a suffix index to indicate which occurrence of the module, e.g. ''{0}.0''"),
    NO_WHITESPACE_IN_DOTTED_NAME(Kind.ERROR, 145, "No whitespace is allowed between dot and components of a name"),
    NAMED_CHANNELS_UNSUPPORTED_HERE(Kind.ERROR, 146, "A named channel is not supported in this kind of definition");

    private Kind kind;
    private int code;
    private String message;

    private XDDSLMessages(Kind kind, int code, String message) {
        this.kind = kind;
        this.code = code;
        this.message = message;
    }

    public String formatMessage(int pos, Object ... inserts) {
        StringBuilder formattedMessage = new StringBuilder();
        formattedMessage.append("XD").append(this.code);
        formattedMessage.append("E");
        formattedMessage.append(":");
        if (pos != -1) {
            formattedMessage.append("(pos ").append(pos).append("): ");
        }
        formattedMessage.append(MessageFormat.format(this.message, inserts));
        return formattedMessage.toString();
    }

    public Kind getKind() {
        return this.kind;
    }

    public static enum Kind {
        INFO,
        WARNING,
        ERROR;

    }
}

